/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllowKnownThumbprintVerifier
implements ThumbprintVerifier {
    private static final Log _logger = LogFactory.getLog(AllowKnownThumbprintVerifier.class);
    private final String[] _knownThumbprints;

    public AllowKnownThumbprintVerifier(String[] knownThumbprints) {
        if (knownThumbprints == null || knownThumbprints.length == 0) {
            throw new IllegalArgumentException("Array of known thumbprints is null or empty");
        }
        for (String knownThumbprint : knownThumbprints) {
            if (knownThumbprint != null && !knownThumbprint.isEmpty()) continue;
            throw new IllegalArgumentException("A thumbprint in the array of known thumbprints is null or empty");
        }
        this._knownThumbprints = (String[])knownThumbprints.clone();
    }

    @Override
    public ThumbprintVerifier.Result verify(String thumbprint) {
        if (thumbprint == null) {
            return ThumbprintVerifier.Result.MISMATCH;
        }
        for (String knownThumbprint : this._knownThumbprints) {
            if (!thumbprint.equalsIgnoreCase(knownThumbprint)) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Accepting connection with thumbprint " + thumbprint));
            }
            return ThumbprintVerifier.Result.MATCH;
        }
        if (_logger.isWarnEnabled()) {
            _logger.warn((Object)("Mismatched thumbprint " + thumbprint + ", rejecting connection"));
        }
        return ThumbprintVerifier.Result.MISMATCH;
    }

    @Override
    public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertion) {
    }
}

