/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.impl.ManagedObjectFactoryImpl;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfigurationCompiler;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpAsyncConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpAsyncConfigurationCompilerImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpAsyncProtocolBindingImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpClient;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingBase;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpSchemeUtils;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientFactory {
    private static final Log LOG = LogFactory.getLog(ClientFactory.class);

    public static HttpClient createClient(URI endPoint, Class<?> version, HttpClientConfiguration config, VmodlContext context) {
        if (config.getHttpConfiguration().getNonBlockingIo()) {
            return ClientFactory.createHttpAsyncClient(endPoint, version, config, context);
        }
        return ClientFactory.createHttpClient(endPoint, version, config, context);
    }

    private static HttpClient createHttpClient(URI endPoint, Class<?> version, HttpClientConfiguration config, VmodlContext context) {
        VmodlVersion vmodlVersion = context.getVmodlVersionMap().getVersion(version);
        ClientFactory.validate(config, endPoint, vmodlVersion);
        HttpConfigurationCompiler compiler = config.getHttpConfigurationCompiler() == null ? new HttpConfigurationCompilerImpl() : config.getHttpConfigurationCompiler();
        compiler.compile(config);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating HTTP client with following properties:\nEnd point: " + endPoint + "\nThread pool: " + config.getExecutor() + "\nResult interceptor: " + config.getResulInterceptor()));
        }
        HttpProtocolBindingImpl binding = new HttpProtocolBindingImpl(endPoint, config.getExecutor(), config.getServerEndpointProvider(), config.getHttpConfiguration());
        return ClientFactory.createClient(binding, config, vmodlVersion, context);
    }

    private static HttpClient createHttpAsyncClient(URI endPoint, Class<?> version, HttpClientConfiguration config, VmodlContext context) {
        VmodlVersion vmodlVersion = context.getVmodlVersionMap().getVersion(version);
        ClientFactory.validate(config, endPoint, vmodlVersion);
        HttpConfigurationCompiler compiler = config.getHttpConfigurationCompiler() == null ? new HttpAsyncConfigurationCompilerImpl() : config.getHttpConfigurationCompiler();
        compiler.compile(config);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating HTTP async client with following properties:\nEnd point: " + endPoint + "\nThread pool: " + config.getExecutor() + "\nI/O thread pool: " + config.getHttpConfiguration().getNioThreadPoolSize() + "\nResult interceptor: " + config.getResulInterceptor()));
        }
        HttpAsyncProtocolBindingImpl binding = new HttpAsyncProtocolBindingImpl(endPoint, config.getExecutor(), config.getServerEndpointProvider(), config.getHttpConfiguration());
        return ClientFactory.createClient(binding, config, vmodlVersion, context);
    }

    private static void validate(HttpClientConfiguration config, URI endPoint, VmodlVersion version) {
        if (version == null) {
            throw new IllegalStateException("Client version not specified");
        }
        if (!(endPoint == null ^ config.getServerEndpointProvider() == null)) {
            throw new IllegalStateException("Invalid endpoint configuration - either static URI or dynamic server URI provider must be configured.");
        }
        if (endPoint != null && !HttpSchemeUtils.checkSchema(endPoint)) {
            throw new IllegalStateException("Unknown scheme " + endPoint.getScheme());
        }
        boolean sync = !config.getHttpConfiguration().getNonBlockingIo();
        CompiledHttpConfiguration compiledConfig = ((HttpConfigurationImpl)config.getHttpConfiguration()).getCompiledConfiguration();
        if (compiledConfig != null && compiledConfig.isActive()) {
            if (sync && !(compiledConfig instanceof CompiledHttpConfigurationImpl)) {
                throw new IllegalArgumentException("Configuration used for async clients can not be used for sync clients");
            }
            if (!sync && !(compiledConfig instanceof CompiledHttpAsyncConfigurationImpl)) {
                throw new IllegalArgumentException("Configuration used for sync clients can not be used for async clients");
            }
        } else {
            if (config.getHttpConfiguration() == null) {
                throw new IllegalArgumentException("Client HTTP configuration is required");
            }
            HttpConfigurationCompiler compiler = config.getHttpConfigurationCompiler();
            if (compiler != null && (sync && !(compiler instanceof HttpConfigurationCompilerImpl) || !sync && !(compiler instanceof HttpAsyncConfigurationCompilerImpl))) {
                throw new IllegalArgumentException("Please, provide correct type of configuration compiler");
            }
        }
    }

    private static HttpClient createClient(HttpProtocolBindingBase binding, ClientConfiguration config, VmodlVersion version, VmodlContext context) {
        binding.setInvocationInterceptor(config.getInvocationInterceptor());
        HttpClient client = new HttpClient(version, binding, config.getManagedObjectFactory() == null ? new ManagedObjectFactoryImpl(binding, config.getRequestContext(), config.getResulInterceptor(), config.getRequestRetryCallback(), config.getRequestContextProvider(), context) : config.getManagedObjectFactory(), context);
        return client;
    }
}

