/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpAsyncConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerBase;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingBase;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vim.vmomi.core.util.DefaultThreadFactory;
import com.vmware.vise.aspect.vlsi.client.thread.HttpConfigurationCompilerBaseAspect;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.protocol.HttpContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class HttpAsyncConfigurationCompilerImpl
extends HttpConfigurationCompilerBase {
    private static final Log LOG = LogFactory.getLog(HttpAsyncConfigurationCompilerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompiledHttpConfiguration compile(HttpClientConfiguration clientConfig) {
        HttpConfigurationImpl configImpl;
        HttpConfiguration config = clientConfig.getHttpConfiguration();
        HttpConfigurationImpl httpConfigurationImpl = configImpl = (HttpConfigurationImpl)config;
        synchronized (httpConfigurationImpl) {
            PoolingNHttpClientConnectionManager connManager;
            if (configImpl.getCompiledConfiguration() != null && configImpl.getCompiledConfiguration().isActive()) {
                return configImpl.getCompiledConfiguration();
            }
            try {
                connManager = this.createConnectionManager(config);
            }
            catch (IOReactorException e) {
                throw new InternalException("Error creating connection manager", e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Compiling HttpConfiguration:\n" + config));
            }
            ConnectionMonitorThread monitor = new ConnectionMonitorThread(connManager, config.getKeepAlivePeriod());
            monitor.start();
            CloseableHttpAsyncClient asyncClient = this.createAsyncHttpClient(config, (NHttpClientConnectionManager)connManager);
            CompiledHttpAsyncConfigurationImpl result = new CompiledHttpAsyncConfigurationImpl(asyncClient, (NHttpClientConnectionManager)connManager, config.getCompressionSupport(), config.getKeepAlivePeriod(), monitor);
            configImpl.resetCompiledConfiguration();
            configImpl.setCompiledConfiguration(result);
            return result;
        }
    }

    protected PoolingNHttpClientConnectionManager createConnectionManager(HttpConfiguration config) throws IOReactorException {
        ConnectingIOReactor ioreactor = this.createConnectingIOReactor(config);
        Registry<SchemeIOSessionStrategy> schemeRegistry = this.createAsyncSchemeRegistry(config);
        PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager(ioreactor, schemeRegistry);
        this.configureConnMgr(connManager, config);
        return connManager;
    }

    protected void configureConnMgr(PoolingNHttpClientConnectionManager connManager, HttpConfiguration config) {
        connManager.setMaxTotal(config.getMaxConnections());
        connManager.setDefaultMaxPerRoute(config.getDefaultMaxConnectionsPerRoute());
        for (HttpConfiguration.RouteConfiguration route : config.getRouteConfigurations()) {
            HttpHost host = new HttpHost(route.getHostName(), route.getPort(), route.getScheme());
            connManager.setMaxPerRoute(new HttpRoute(host), route.getMaxConnections());
        }
    }

    protected ConnectingIOReactor createConnectingIOReactor(HttpConfiguration config) throws IOReactorException {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.getNioThreadPoolSize()).setTcpNoDelay(config.getDisableNagle()).setSoTimeout(config.getTimeoutMs()).setConnectTimeout(config.getConnectTimeoutMs()).build();
        return new DefaultConnectingIOReactor(ioReactorConfig, (ThreadFactory)new DefaultThreadFactory("VLSI-I/O dispatcher-"));
    }

    protected Registry<SchemeIOSessionStrategy> createAsyncSchemeRegistry(HttpConfiguration config) {
        RegistryBuilder builder = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE);
        ThumbprintTrustManager trustManager = this.createThumbprintTrustManager(config);
        SSLContext sslContext = this.createSSLContext(config, trustManager);
        ThumbprintTrustManager thumbprintTrustManager = trustManager;
        thumbprintTrustManager.getClass();
        builder.register("https", (Object)thumbprintTrustManager.new ThumbprintTrustManager.VlsiSslIoSessionStrategy(sslContext, config.getEnabledProtocols()));
        return builder.build();
    }

    protected CloseableHttpAsyncClient createAsyncHttpClient(HttpConfiguration config, NHttpClientConnectionManager connManager) {
        CloseableHttpAsyncClient client;
        final long keepAlivePeriod = config.getKeepAlivePeriod();
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(false).setStaleConnectionCheckEnabled(config.getCheckStaleConnection()).setSocketTimeout(config.getTimeoutMs()).setConnectTimeout(config.getConnectTimeoutMs()).setCookieSpec("standard").build();
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setUserAgent(config.getUserAgent()).setConnectionManager(connManager).setDefaultRequestConfig(requestConfig).setDefaultCookieSpecRegistry(HttpProtocolBindingBase.createCookieSpecProviderRegistry()).setThreadFactory((ThreadFactory)new DefaultThreadFactory("VLSI-I/O reactor-")).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return keepAlivePeriod;
            }
        });
        if (config.getDefaultProxyHost() != null) {
            builder.setProxy(new HttpHost(config.getDefaultProxyHost(), config.getDefaultProxyPort(), config.getDefaultProxyScheme()));
        }
        if (!(client = builder.build()).isRunning()) {
            client.start();
        }
        return client;
    }

    private static final class ConnectionMonitorThread
    extends HttpConfigurationCompilerBase.ConnectionMonitorThreadBase {
        private final NHttpClientConnectionManager connManager;
        private final long keepAlivePeriod;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public ConnectionMonitorThread(PoolingNHttpClientConnectionManager connManager, long keepAlivePeriod) {
            super((ConnPoolControl<HttpRoute>)connManager);
            PoolingNHttpClientConnectionManager poolingNHttpClientConnectionManager = connManager;
            long l = keepAlivePeriod;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)poolingNHttpClientConnectionManager, (Object)Conversions.longObject((long)l));
            this.connManager = connManager;
            this.keepAlivePeriod = keepAlivePeriod;
            HttpConfigurationCompilerBaseAspect.aspectOf().logStackTrace(joinPoint);
        }

        @Override
        protected void closeConnections() {
            this.connManager.closeExpiredConnections();
            this.connManager.closeIdleConnections(this.keepAlivePeriod, TimeUnit.MILLISECONDS);
        }

        static {
            ConnectionMonitorThread.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("HttpAsyncConfigurationCompilerImpl.java", ConnectionMonitorThread.class);
            ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.vmware.vim.vmomi.client.http.impl.HttpAsyncConfigurationCompilerImpl$ConnectionMonitorThread", "org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager:long", "connManager:keepAlivePeriod", ""), 76);
        }
    }
}

