/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.HttpAsyncProtocolBindingImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpExchangeBase;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.protocol.HttpContext;

public class HttpAsyncExchange
extends HttpExchangeBase {
    private final HttpAsyncClient _client;
    private final HttpAsyncProtocolBindingImpl _binding;
    private final boolean _sync;
    private HttpClientContext httpContext;

    public HttpAsyncExchange(Request request, Response response, CompiledHttpConfiguration compiledHttpConfig, HttpAsyncClient client, URI endpoint, boolean enableCompression, InvocationInterceptor invocationInterceptor, HttpAsyncProtocolBindingImpl binding, boolean sync) {
        super(request, response, compiledHttpConfig, endpoint, enableCompression, invocationInterceptor);
        this._client = client;
        this._binding = binding;
        this._sync = sync;
    }

    @Override
    public void run() {
        HttpPost post;
        this.beginInvocation();
        try {
            post = this.prepareRequest();
            this.httpContext = this.prepareContext();
        }
        catch (Exception e) {
            this.getResponse().setError(e);
            return;
        }
        this._client.execute((HttpUriRequest)post, (HttpContext)this.httpContext, this.createCallback());
    }

    private HttpClientContext prepareContext() {
        HttpClientContext result = this.prepareLocalContext();
        result.setCookieStore(this._binding.getCookieStore());
        return result;
    }

    private FutureCallback<HttpResponse> createCallback() {
        return new FutureCallback<HttpResponse>(){

            public void failed(final Exception e) {
                HttpAsyncExchange.this._binding.executeRunnable(new Runnable(){

                    @Override
                    public void run() {
                        HttpAsyncExchange.this.getResponse().setError(e);
                        HttpAsyncExchange.this.completeInvocation(false);
                    }
                }, HttpAsyncExchange.this._sync);
            }

            public void completed(final HttpResponse response) {
                HttpAsyncExchange.this._binding.executeRunnable(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean success = true;
                        try {
                            HttpAsyncExchange.this.parseLocalContext(HttpAsyncExchange.this.httpContext);
                            HttpAsyncExchange.this.parseResponse(response);
                        }
                        catch (Exception e) {
                            success = false;
                            HttpAsyncExchange.this.getResponse().setError(e);
                        }
                        catch (Throwable e) {
                            success = false;
                            HttpAsyncExchange.this.getResponse().setError(new RuntimeException(e));
                        }
                        finally {
                            HttpAsyncExchange.this.completeInvocation(success);
                        }
                    }
                }, HttpAsyncExchange.this._sync);
            }

            public void cancelled() {
                HttpAsyncExchange.this._binding.executeRunnable(new Runnable(){

                    @Override
                    public void run() {
                        HttpAsyncExchange.this.getResponse().setError(new TransportProtocolException("Http exchange canceled."));
                        HttpAsyncExchange.this.completeInvocation(false);
                    }
                }, HttpAsyncExchange.this._sync);
            }
        };
    }
}

