/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfigurationCompiler;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.KeyManagerWrapper;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vim.vmomi.client.http.util.VecsUtils;
import com.vmware.vim.vmomi.core.common.LifecycleListener;
import com.vmware.vim.vmomi.core.util.ClassUtil;
import com.vmware.vim.vmomi.core.util.FileUtil;
import com.vmware.vise.aspect.vlsi.client.thread.HttpConfigurationCompilerBaseAspect;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.pool.ConnPoolControl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class HttpConfigurationCompilerBase
implements HttpConfigurationCompiler {
    protected KeyManager[] createKeyManagers(HttpConfiguration config) {
        String password = config.getKeyStoreConfig().getKeyPassword();
        String alias = config.getKeyStoreConfig().getKeyAlias();
        try {
            if (password != null && alias != null) {
                KeyStore store = this.loadKeyStore(config);
                KeyManagerFactory keyMngrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyMngrFactory.init(store, password.toCharArray());
                KeyManager[] keyManagers = keyMngrFactory.getKeyManagers();
                for (int i = 0; i < keyManagers.length; ++i) {
                    if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                    keyManagers[i] = new KeyManagerWrapper((X509KeyManager)keyManagers[i], alias);
                }
                return keyManagers;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create KeyManagers", e);
        }
        return null;
    }

    protected KeyStore loadTrustStore(HttpConfiguration config) {
        KeyStore vecsTrustStore = VecsUtils.getVecsTrustStore();
        if (vecsTrustStore != null) {
            return vecsTrustStore;
        }
        if (config.getTrustStore() != null) {
            return config.getTrustStore();
        }
        return this.createKeyStore(config.getKeyStoreConfig().getTrustStorePath(), config.getKeyStoreConfig().getTrustStorePassword(), "JKS");
    }

    private CertStore loadCrlCertStore(HttpConfiguration config) {
        CertStore result = null;
        result = VecsUtils.getVecsCertStore();
        if (result == null) {
            result = config.getCrlCertStore();
        }
        return result;
    }

    protected KeyStore loadKeyStore(HttpConfiguration config) {
        if (config.getKeyStore() != null) {
            return config.getKeyStore();
        }
        return this.createKeyStore(config.getKeyStoreConfig().getKeyStorePath(), config.getKeyStoreConfig().getKeyStorePassword(), config.getKeyStoreConfig().getKeyStoreType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createKeyStore(String path, String password, String type) {
        try {
            KeyStore keyStore = KeyStore.getInstance(type.toUpperCase());
            if (path != null && password != null) {
                ClassLoader loader = ClassUtil.getCurrentClassLoader();
                InputStream stream = FileUtil.getInputStream((String)path, (ClassLoader)loader);
                try {
                    keyStore.load(stream, password.toCharArray());
                }
                finally {
                    stream.close();
                }
            } else {
                keyStore.load(null);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create default client trust/key store", e);
        }
    }

    protected ThumbprintVerifier createThumbprintVerifier(HttpConfiguration config) {
        return config.getThumbprintVerifier();
    }

    protected ThumbprintTrustManager createThumbprintTrustManager(HttpConfiguration config) {
        return new ThumbprintTrustManager(this.loadTrustStore(config), this.loadCrlCertStore(config), this.createThumbprintVerifier(config), "SHA-1");
    }

    protected SSLContext createSSLContext(HttpConfiguration config, ThumbprintTrustManager trustManager) {
        SSLContext sslContext = null;
        KeyManager[] keyManagers = this.createKeyManagers(config);
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalException("Unable to create SSLContext", e);
        }
        catch (KeyManagementException e) {
            throw new InternalException("Unable to create SSLContext", e);
        }
        return sslContext;
    }

    protected static abstract class ConnectionMonitorThreadBase
    extends Thread
    implements LifecycleListener {
        private static final String THREAD_NAME = "VLSI-client-connection-monitor";
        private static final Log LOG;
        private static AtomicInteger suffix;
        private final ConnPoolControl<HttpRoute> statsMgr;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        protected ConnectionMonitorThreadBase(ConnPoolControl<HttpRoute> statsMgr) {
            super(String.format("%s-%d", THREAD_NAME, suffix.getAndIncrement()));
            this.setDaemon(true);
            this.statsMgr = statsMgr;
        }

        protected abstract void closeConnections();

        @Override
        public void run() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            ConnectionMonitorThreadBase.run_aroundBody1$advice(this, joinPoint, HttpConfigurationCompilerBaseAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        public void shutdown() {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Shutting down the connection monitor.");
            }
            this.interrupt();
        }

        public void shutdownNow() {
            throw new UnsupportedOperationException();
        }

        private void cleanUp() {
            int connectionCountAfter;
            int connectionCount = -1;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("Cleaning up expired connections, connection count before cleanup: %s", connectionCount));
            } else if (LOG.isDebugEnabled()) {
                connectionCount = this.statsMgr.getTotalStats().getAvailable();
            }
            this.closeConnections();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("Connection count after cleanup: %s", this.statsMgr.getTotalStats().getAvailable()));
            } else if (LOG.isDebugEnabled() && connectionCount != (connectionCountAfter = this.statsMgr.getTotalStats().getAvailable())) {
                LOG.debug((Object)String.format("Cleaning expired connections. Connection count before: %s, after: %s", connectionCount, connectionCountAfter));
            }
        }

        static {
            ConnectionMonitorThreadBase.ajc$preClinit();
            LOG = LogFactory.getLog(ConnectionMonitorThreadBase.class);
            suffix = new AtomicInteger();
        }

        private static final /* synthetic */ void run_aroundBody0(ConnectionMonitorThreadBase ajc$this, JoinPoint joinPoint) {
            block3: {
                try {
                    while (!ajc$this.isInterrupted()) {
                        ConnectionMonitorThreadBase.sleep(10000L);
                        ajc$this.cleanUp();
                    }
                }
                catch (InterruptedException ex) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)"Interrupted, no more connection pool cleanups will be performed.");
                }
            }
        }

        private static final /* synthetic */ Object run_aroundBody1$advice(ConnectionMonitorThreadBase ajc$this, JoinPoint thisJoinPoint, HttpConfigurationCompilerBaseAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint) {
            String threadName = Thread.currentThread().getName();
            try {
                Object result;
                HttpConfigurationCompilerBaseAspect.ajc$inlineAccessFieldGet$com_vmware_vise_aspect_vlsi_client_thread_HttpConfigurationCompilerBaseAspect$com_vmware_vise_aspect_vlsi_client_thread_HttpConfigurationCompilerBaseAspect$_logger().info((Object)(String.valueOf(threadName) + " thread started..."));
                ProceedingJoinPoint proceedingJoinPoint = joinPoint;
                ConnectionMonitorThreadBase.run_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint);
                Object var7_7 = result = null;
                return var7_7;
            }
            finally {
                HttpConfigurationCompilerBaseAspect.ajc$inlineAccessFieldGet$com_vmware_vise_aspect_vlsi_client_thread_HttpConfigurationCompilerBaseAspect$com_vmware_vise_aspect_vlsi_client_thread_HttpConfigurationCompilerBaseAspect$_logger().info((Object)(String.valueOf(threadName) + " thread ended."));
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("HttpConfigurationCompilerBase.java", ConnectionMonitorThreadBase.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerBase$ConnectionMonitorThreadBase", "", "", "", "void"), 74);
        }
    }
}

