/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.exception.VlsiCertificateException;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOSession;

public class ThumbprintTrustManager
implements X509TrustManager {
    private static final Log LOG = LogFactory.getLog(ThumbprintTrustManager.class);
    private final KeyStore _trustStore;
    private final ThumbprintVerifier _thumbprintVerifier;
    private final String _thumbprintAlgorithm;
    private final CertStore _crlCertStore;
    private X509TrustManager _lastTrustManager;
    private final ThreadLocal<ChainInfo> _tlsChainInfo;

    public ThumbprintTrustManager(KeyStore trustStore, ThumbprintVerifier verifier) {
        this(trustStore, verifier, "SHA-1");
    }

    public ThumbprintTrustManager(KeyStore trustStore, ThumbprintVerifier verifier, String algorithm) {
        this(trustStore, null, verifier, algorithm);
    }

    public ThumbprintTrustManager(KeyStore trustStore, CertStore crlCertStore, ThumbprintVerifier verifier, String algorithm) {
        this._trustStore = trustStore;
        this._thumbprintAlgorithm = algorithm;
        this._crlCertStore = crlCertStore;
        this._thumbprintVerifier = verifier;
        this._tlsChainInfo = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        String certThumbprint = null;
        ThumbprintVerifier.Result verifyResult = ThumbprintVerifier.Result.UNKNOWN;
        boolean isTrusted = false;
        try {
            this.checkForRevocation(chain);
            try {
                certThumbprint = SslUtil.computeCertificateThumbprint((X509Certificate)chain[0], (String)this._thumbprintAlgorithm);
            }
            catch (Exception e) {
                LOG.debug((Object)"Failed to calculate certificate thumbprint", (Throwable)e);
                throw new CertificateException("Unable to compute server certificate thumbprint", e);
            }
            if (this._thumbprintVerifier != null) {
                verifyResult = this._thumbprintVerifier.verify(certThumbprint);
            }
            this._lastTrustManager = this.getDefaultTrustManager();
            this._lastTrustManager.checkServerTrusted(chain, authType);
            LOG.debug((Object)"Server certificate chain is trusted");
            isTrusted = true;
        }
        catch (Exception e) {
            LOG.debug((Object)"Server certificate chain is not trusted", (Throwable)e);
            if (verifyResult != ThumbprintVerifier.Result.MATCH) {
                String thumbprintState = this._thumbprintVerifier == null ? "thumbprint verification is not configured" : "thumbprint doesn't match";
                throw new VlsiCertificateException("Server certificate chain is not trusted and " + thumbprintState, chain, certThumbprint, isTrusted, e);
            }
            LOG.debug((Object)"Server certificate chain is not trusted but thumbprint matches");
        }
        finally {
            this._tlsChainInfo.set(new ChainInfo(chain, certThumbprint, verifyResult, isTrusted));
        }
    }

    private void checkForRevocation(X509Certificate[] chain) throws CertificateException {
        if (this._crlCertStore == null) {
            return;
        }
        try {
            for (X509Certificate cert : chain) {
                X509CRLSelector selector = new X509CRLSelector();
                selector.setCertificateChecking(cert);
                for (CRL cRL : this._crlCertStore.getCRLs(selector)) {
                    if (!cRL.isRevoked(cert)) continue;
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)String.format("The following server certificate is on the CRL:\n%s", cert));
                    }
                    throw new CertificateException("Server certificate is revoked");
                }
            }
        }
        catch (CertStoreException e) {
            throw new CertificateException("Failed to validate certificate against CertStore CRL", e);
        }
    }

    private X509TrustManager getDefaultTrustManager() {
        TrustManagerFactory factory = this.createTrustManagerFactory();
        for (TrustManager trustManager : factory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("Unable to find default trust manager");
    }

    private TrustManagerFactory createTrustManagerFactory() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance("PKIX");
            factory.init(this._trustStore);
            return factory;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create trust manager factory", e);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Unable to initialize trust manager factory", e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.getDefaultTrustManager().checkClientTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509TrustManager trustManager = this._lastTrustManager;
        if (trustManager == null) {
            LOG.debug((Object)"Abnormal path of SSL-trust-manager execution", (Throwable)new RuntimeException());
            trustManager = this.getDefaultTrustManager();
        }
        return trustManager.getAcceptedIssuers();
    }

    private String formatHost(String host) {
        if (host != null && host.startsWith("[") && host.endsWith("]")) {
            try {
                return InetAddress.getByName(host).getHostAddress();
            }
            catch (UnknownHostException e) {
                return host;
            }
        }
        return host;
    }

    public class VlsiSslIoSessionStrategy
    extends SSLIOSessionStrategy {
        VlsiSslIoSessionStrategy(SSLContext sslContext, String[] supportedProtocols) {
            super(sslContext, supportedProtocols, null, STRICT_HOSTNAME_VERIFIER);
        }

        protected void verifySession(HttpHost host, IOSession iosession, SSLSession sslsession) throws SSLException {
            try {
                ChainInfo chainInfo;
                boolean assertionVerified;
                block8: {
                    Certificate[] certs = sslsession.getPeerCertificates();
                    X509Certificate x509 = (X509Certificate)certs[0];
                    assertionVerified = false;
                    chainInfo = (ChainInfo)ThumbprintTrustManager.this._tlsChainInfo.get();
                    ThumbprintTrustManager.this._tlsChainInfo.set(null);
                    try {
                        STRICT_HOSTNAME_VERIFIER.verify(ThumbprintTrustManager.this.formatHost(host.getHostName()), x509);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Server certificate assertion verified");
                        }
                        assertionVerified = true;
                    }
                    catch (SSLException e) {
                        if (null != chainInfo && chainInfo._verifyResult != ThumbprintVerifier.Result.MATCH) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Server certificate assertion not verified and thumbprint not matched for " + chainInfo));
                            }
                            throw new CertificateValidationException("Server certificate assertion not verified and thumbprint not matched", chainInfo._chain, chainInfo._thumbprint, chainInfo._isTrusted, (Throwable)e);
                        }
                        if (!LOG.isDebugEnabled()) break block8;
                        LOG.debug((Object)"Server certificate assertion not verified but thumbprint matches");
                    }
                }
                if (null != chainInfo && ThumbprintTrustManager.this._thumbprintVerifier != null) {
                    ThumbprintTrustManager.this._thumbprintVerifier.onSuccess(chainInfo._chain, chainInfo._thumbprint, chainInfo._verifyResult, chainInfo._isTrusted, assertionVerified);
                }
            }
            catch (SSLException e) {
                sslsession.invalidate();
                throw e;
            }
        }
    }

    public class HostnameVerifier
    implements X509HostnameVerifier {
        public void verify(String host, SSLSocket socket) throws IOException {
            try {
                socket.startHandshake();
            }
            catch (IOException e) {
                this.handleHandshakeException(e, null);
            }
            SSLSession session = socket.getSession();
            if (session == null) {
                InputStream in = socket.getInputStream();
                in.available();
                session = socket.getSession();
                if (session == null) {
                    try {
                        socket.startHandshake();
                    }
                    catch (IOException e) {
                        this.handleHandshakeException(e, null);
                    }
                    session = socket.getSession();
                }
            }
            Certificate[] certificates = null;
            try {
                certificates = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                this.handleHandshakeException(e, session);
            }
            try {
                this.verify(host, (X509Certificate)certificates[0]);
            }
            catch (SSLException e) {
                session.invalidate();
                throw e;
            }
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
            ChainInfo chainInfo;
            boolean assertionVerified;
            block6: {
                assertionVerified = false;
                chainInfo = (ChainInfo)ThumbprintTrustManager.this._tlsChainInfo.get();
                ThumbprintTrustManager.this._tlsChainInfo.set(null);
                try {
                    SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(ThumbprintTrustManager.this.formatHost(host), cert);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Server certificate assertion verified");
                    }
                    assertionVerified = true;
                }
                catch (SSLException e) {
                    if (null != chainInfo && chainInfo._verifyResult != ThumbprintVerifier.Result.MATCH) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Server certificate assertion not verified and thumbprint not matched for " + chainInfo));
                        }
                        throw new CertificateValidationException("Server certificate assertion not verified and thumbprint not matched", chainInfo._chain, chainInfo._thumbprint, chainInfo._isTrusted, (Throwable)e);
                    }
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug((Object)"Server certificate assertion not verified but thumbprint matches");
                }
            }
            if (null != chainInfo && ThumbprintTrustManager.this._thumbprintVerifier != null) {
                ThumbprintTrustManager.this._thumbprintVerifier.onSuccess(chainInfo._chain, chainInfo._thumbprint, chainInfo._verifyResult, chainInfo._isTrusted, assertionVerified);
            }
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(ThumbprintTrustManager.this.formatHost(host), cns, subjectAlts);
        }

        public boolean verify(String host, SSLSession session) {
            try {
                Certificate[] certificates = session.getPeerCertificates();
                this.verify(host, (X509Certificate)certificates[0]);
                return true;
            }
            catch (SSLException e) {
                return false;
            }
        }

        private void handleHandshakeException(IOException e, SSLSession session) throws SSLException {
            if (session != null) {
                session.invalidate();
            }
            ChainInfo chainInfo = (ChainInfo)ThumbprintTrustManager.this._tlsChainInfo.get();
            this.logSslData(chainInfo, session);
            if (chainInfo != null) {
                ThumbprintTrustManager.this._tlsChainInfo.set(null);
                throw new CertificateValidationException("Server certificate chain not verified", chainInfo._chain, chainInfo._thumbprint, chainInfo._isTrusted, (Throwable)e);
            }
            throw new SSLException("Server certificate chain not verified (no details)", e);
        }

        private void logSslData(ChainInfo chainInfo, SSLSession session) {
            if (LOG.isDebugEnabled()) {
                String msg = null;
                msg = chainInfo != null ? "Server certificate chain not verified for %6$s\n" : "Server certificate chain not verified\n";
                if (session != null) {
                    msg = msg + "Peer host: %1$s\nProtocol: %2$s\nCiphersuite: %3$s\nSSL session creation date: %4$s\nSSL session last access: %5$s";
                    LOG.debug((Object)String.format(msg, session.getPeerHost(), session.getProtocol(), session.getCipherSuite(), new Date(session.getCreationTime()), new Date(session.getLastAccessedTime()), chainInfo));
                } else {
                    msg = "Server certificate chain not verified for %1$s";
                    LOG.debug((Object)String.format(msg, chainInfo));
                }
            }
        }
    }

    private static class ChainInfo {
        X509Certificate[] _chain;
        String _thumbprint;
        ThumbprintVerifier.Result _verifyResult;
        boolean _isTrusted;

        ChainInfo(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean isTrusted) {
            this._chain = chain;
            this._thumbprint = thumbprint;
            this._verifyResult = verifyResult;
            this._isTrusted = isTrusted;
        }

        public String toString() {
            return String.format("Certificate: %s\nThumbprint: %s\nResult: %s\nTrusted: %b", new Object[]{this._chain != null && this._chain.length > 0 ? this._chain[0] : "certificate not present", this._thumbprint, this._verifyResult, this._isTrusted});
        }
    }
}

