/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import java.io.EOFException;
import java.io.IOException;
import java.net.NoRouteToHostException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

public class VlsiRequestRetryHandler
implements HttpRequestRetryHandler {
    private static final Log LOG = LogFactory.getLog(VlsiRequestRetryHandler.class);
    private final HttpRequestRetryHandler _defaultHandler;
    private final int _retryClosedSslHandshakeLimit;
    private final int _retryLimit;

    public VlsiRequestRetryHandler(int retryLimit, int retryClosedSslHandshakeLimit) {
        this._defaultHandler = new DefaultHttpRequestRetryHandler(retryLimit, false);
        this._retryLimit = retryLimit;
        this._retryClosedSslHandshakeLimit = retryClosedSslHandshakeLimit;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (exception instanceof NoRouteToHostException) {
            LOG.debug((Object)"NoRouteToHostException would not be retried.");
            return false;
        }
        boolean retry = false;
        String logMessage = "A retryable exception occurred.";
        int maxRetries = this._retryLimit;
        if (VlsiRequestRetryHandler.isExceptionDueToClosedSslHandshake(exception)) {
            if (executionCount > this._retryClosedSslHandshakeLimit) {
                return false;
            }
            logMessage = "Remote host closed connection during the initial SSL handshake.";
            retry = true;
            maxRetries = this._retryClosedSslHandshakeLimit;
        } else {
            retry = this._defaultHandler.retryRequest(exception, executionCount, context);
        }
        if (retry && LOG.isDebugEnabled()) {
            logMessage = String.format("%s Retry %d out of %d about to be performed.", logMessage, executionCount, maxRetries);
            LOG.debug((Object)logMessage, (Throwable)exception);
        }
        return retry;
    }

    private static boolean isExceptionDueToClosedSslHandshake(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof SSLHandshakeException && exception.getCause() instanceof EOFException) {
            return true;
        }
        return VlsiRequestRetryHandler.isExceptionDueToClosedSslHandshake(exception.getCause());
    }
}

