/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search;

import com.vmware.vise.metadata.ObjectModelProvider;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.util.Directory;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ObjectModelProviderDirectory
implements Directory<ObjectModelProvider> {
    private static final String[] EMPTY_TYPE_ARRAY = new String[0];
    private final ConcurrentMap<String, ObjectModelProvider> _providerByNamespace;
    private final DelegatingObjectModelProvider _delegatingProvider;

    public ObjectModelProviderDirectory() {
        int n = 8;
        float f = 0.75f;
        int n2 = 2;
        this._providerByNamespace = new ConcurrentHashMap<String, ObjectModelProvider>(n, f, n2);
        this._delegatingProvider = new DelegatingObjectModelProvider();
    }

    public ObjectModelProvider addIfAbsent(String string, ObjectModelProvider objectModelProvider) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectModelProvider});
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Namespace cannot be null or empty");
        }
        ObjectModelProvider objectModelProvider2 = this._providerByNamespace.putIfAbsent(string, objectModelProvider);
        return objectModelProvider2;
    }

    public ObjectModelProvider add(String string, ObjectModelProvider objectModelProvider) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectModelProvider});
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Namespace cannot be null or empty");
        }
        ObjectModelProvider objectModelProvider2 = this._providerByNamespace.put(string, objectModelProvider);
        return objectModelProvider2;
    }

    public ObjectModelProvider remove(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        ObjectModelProvider objectModelProvider = (ObjectModelProvider)this._providerByNamespace.remove(string);
        return objectModelProvider;
    }

    public ObjectModelProvider get(String string) {
        return this._delegatingProvider;
    }

    private final class DelegatingObjectModelProvider
    implements ObjectModelProvider {
        DelegatingObjectModelProvider() {
        }

        public String getImmediateSuperType(String string) {
            String string2 = NamespaceUtils.getNamespace(string);
            ObjectModelProvider objectModelProvider = null;
            if (string2 != null) {
                objectModelProvider = (ObjectModelProvider)ObjectModelProviderDirectory.this._providerByNamespace.get(string2);
            }
            if (objectModelProvider == null) {
                return null;
            }
            String string3 = objectModelProvider.getImmediateSuperType(string);
            return string3;
        }

        public String[] getSuperTypes(String string) {
            String string2 = NamespaceUtils.getNamespace(string);
            ObjectModelProvider objectModelProvider = null;
            if (string2 != null) {
                objectModelProvider = (ObjectModelProvider)ObjectModelProviderDirectory.this._providerByNamespace.get(string2);
            }
            if (objectModelProvider == null) {
                return EMPTY_TYPE_ARRAY;
            }
            return objectModelProvider.getSuperTypes(string);
        }
    }
}

