/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search;

import com.vmware.vise.search.SearchServiceExtensionRegistry;
import com.vmware.vise.util.XMLUtil;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SearchMetadataRegistrar {
    private static final Logger _logger = LoggerFactory.getLogger(SearchMetadataRegistrar.class);

    public SearchMetadataRegistrar(SearchServiceExtensionRegistry searchServiceExtensionRegistry, String string) {
        this(searchServiceExtensionRegistry, string, null);
    }

    public SearchMetadataRegistrar(SearchServiceExtensionRegistry searchServiceExtensionRegistry, String string, String string2) {
        this(searchServiceExtensionRegistry, string, string2, null);
    }

    public SearchMetadataRegistrar(SearchServiceExtensionRegistry searchServiceExtensionRegistry, String string, String string2, ClassLoader classLoader) {
        this.registerSearchMetadata(searchServiceExtensionRegistry, string, string2, classLoader);
    }

    private void registerSearchMetadata(SearchServiceExtensionRegistry searchServiceExtensionRegistry, String string, String string2, ClassLoader classLoader) {
        Object object;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        Document document = null;
        try {
            object = classLoader.getResourceAsStream(string);
            document = XMLUtil.loadXmlFile((InputStream)object);
        }
        catch (Exception exception) {
            _logger.error("Error loading xml file from location: " + string, (Throwable)exception);
        }
        if (document == null) {
            return;
        }
        _logger.info("Start registering metadata from file: {}", (Object)string);
        object = this.getSourceId(string);
        searchServiceExtensionRegistry.registerMetadata((String)object, document, classLoader, string2);
        _logger.info("Metadata have been registered from file: {}", (Object)string);
    }

    private String getSourceId(String string) {
        int n = string.lastIndexOf("/") + 1;
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }
}

