/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search;

import com.vmware.vise.metadata.ObjectModelProvider;

public final class TypeRef {
    private static final String[] EMPTY_TYPE_ARRAY = new String[0];
    private final String _name;
    private final ObjectModelProvider _provider;

    public TypeRef(String string, ObjectModelProvider objectModelProvider) {
        if (string == null) {
            throw new IllegalArgumentException("name param cannot be null");
        }
        if (objectModelProvider == null) {
            throw new IllegalArgumentException("provider param cannot be null");
        }
        this._name = string;
        this._provider = objectModelProvider;
    }

    public String getName() {
        return this._name;
    }

    public boolean isAssignableFrom(TypeRef typeRef) {
        if (typeRef == null) {
            return false;
        }
        if (this.equals(typeRef)) {
            return true;
        }
        String[] stringArray = typeRef._provider.getSuperTypes(typeRef.getName());
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (!this._name.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isInstanceOf(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(this._name)) {
            return true;
        }
        String[] stringArray = this.getSuperTypes();
        if (stringArray == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public String[] getSuperTypes() {
        String[] stringArray = this._provider.getSuperTypes(this._name);
        if (stringArray != null) {
            return stringArray;
        }
        return EMPTY_TYPE_ARRAY;
    }

    public String getImmediateSuperType() {
        String string = this._provider.getImmediateSuperType(this._name);
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TypeRef) {
            TypeRef typeRef = (TypeRef)object;
            return this._name.equals(typeRef.getName());
        }
        return false;
    }

    public boolean equalsIgnoreCase(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TypeRef) {
            TypeRef typeRef = (TypeRef)object;
            return this._name.equalsIgnoreCase(typeRef.getName());
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }
}

