/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.impl.QueryElement;
import com.vmware.vise.search.impl.SetExpr;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.LetClauseExpression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.ParenthesizedExpression;
import com.vmware.vise.search.xquery.PredicatedExpression;
import com.vmware.vise.search.xquery.PrimaryExpression;
import com.vmware.vise.search.xquery.RangeExpression;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

final class EntitySetDescriptor
implements QueryElement {
    private String _baseSetExpr;
    private Boolean _cardinalityMultiple;
    private Boolean _writeExprAsSingular;
    private SetExpr _setExpr;
    private String _entityType;
    private String _resourceModel;
    private final MetadataDirectory _metadataDirectory;
    public String id;
    public ConstraintInternal constraint;

    @Override
    public String getEntityType() {
        if (this._entityType == null) {
            return TypeRefUtils.ROOT_TYPEREF.getName();
        }
        return this._entityType;
    }

    @Override
    public void setEntityType(String string) {
        this._entityType = string;
    }

    @Override
    public String getResourceModel() {
        return this._resourceModel;
    }

    @Override
    public void setResourceModel(String string) {
        this._resourceModel = string;
    }

    public boolean isCardinalityMultiple() {
        return this._cardinalityMultiple == null ? true : this._cardinalityMultiple;
    }

    public void setCardinalityMultiple(boolean bl) {
        this._cardinalityMultiple = bl;
    }

    public boolean isWriteExprAsSingular() {
        return this._writeExprAsSingular == null ? false : this._writeExprAsSingular;
    }

    public void setWriteExprAsSingular(boolean bl) {
        this._writeExprAsSingular = bl;
    }

    public SetExpr getSetExpr() {
        return this._setExpr;
    }

    public void setSetExpr(SetExpr setExpr) {
        this._setExpr = setExpr;
        if (this._setExpr != null && this._setExpr.getParent() == null) {
            this._setExpr.setParent(this);
        }
    }

    public String getExpr() {
        return this._baseSetExpr;
    }

    public void setExpr(String string) {
        this._baseSetExpr = string;
    }

    private EntitySetDescriptor(MetadataDirectory metadataDirectory) {
        this._metadataDirectory = metadataDirectory;
    }

    public MetadataDirectory getMetadataDirectory() {
        return this._metadataDirectory;
    }

    static EntitySetDescriptor newInstance(String string, String string2, MetadataDirectory metadataDirectory) {
        EntitySetDescriptor entitySetDescriptor = new EntitySetDescriptor(metadataDirectory);
        entitySetDescriptor.id = string;
        entitySetDescriptor.setEntityType(string2);
        entitySetDescriptor.setSetExpr(new SetExpr(metadataDirectory));
        return entitySetDescriptor;
    }

    public String toString() {
        String string = this.evaluate("/*");
        return this.toDeclaration("Set", string);
    }

    String toDeclaration(String string, String string2) {
        Expression expression;
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, string2});
        VarRefExpression varRefExpression = new VarRefExpression(this.id + string);
        Expression expression2 = new LiteralExpression(string2);
        if (this.isCardinalityMultiple() && this.isWriteExprAsSingular()) {
            expression = new ParenthesizedExpression(expression2);
            RangeExpression rangeExpression = new RangeExpression(1);
            expression2 = new PredicatedExpression((PrimaryExpression)expression, rangeExpression);
        }
        expression = new LetClauseExpression(varRefExpression, expression2);
        return expression.evaluate();
    }

    @Override
    public String evaluate(String string) {
        SetExpr setExpr = this._setExpr;
        if ((setExpr == null || setExpr.isUnset()) && !Strings.isNullOrEmpty(this._baseSetExpr)) {
            String string2 = XQueryUtils.replaceCascadingClausesWithAnd(this._baseSetExpr);
            return string2;
        }
        String string3 = this._baseSetExpr;
        if (Strings.isNullOrEmpty(string3)) {
            string3 = XQueryUtils.typeMatchingExpression(this.getEntityType(), this._metadataDirectory);
        }
        String string4 = setExpr.evaluate(string3);
        string4 = XQueryUtils.replaceCascadingClausesWithAnd(string4);
        return string4;
    }

    static String[] toUniqueSetDefnClauses(List<EntitySetDescriptor> list, String string) {
        boolean bl = true;
        return EntitySetDescriptor.toSetDefnClauses(list, string, bl);
    }

    static String[] toSetDefnClauses(List<EntitySetDescriptor> list, String string) {
        boolean bl = false;
        return EntitySetDescriptor.toSetDefnClauses(list, string, bl);
    }

    static String[] toSetDefnClauses(List<EntitySetDescriptor> list, String string, boolean bl) {
        HashSet<String> hashSet = null;
        if (bl) {
            hashSet = new HashSet<String>(list.size());
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (EntitySetDescriptor entitySetDescriptor : list) {
            String string2 = entitySetDescriptor.evaluate(null);
            if (bl) {
                if (hashSet.contains(string2)) continue;
                hashSet.add(string2);
            }
            String string3 = entitySetDescriptor.toDeclaration(string, string2);
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

