/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.FacetSpec;
import com.vmware.vise.search.PropertySpec;
import com.vmware.vise.search.QueryContextType;
import com.vmware.vise.search.impl.PropertySpecExprBuilder;
import com.vmware.vise.search.metadata.Descriptor;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.search.xquery.render.RendererFactory;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;

public class FacetExprGenerator {
    private final MetadataDirectory _metadataDirectory;
    private final RendererFactory _rendererFactory;

    public FacetExprGenerator(MetadataDirectory metadataDirectory, RendererFactory rendererFactory) {
        this._metadataDirectory = metadataDirectory;
        this._rendererFactory = rendererFactory;
    }

    public String generateQueryExprForFacetSpecs(FacetSpec[] facetSpecArray) {
        if (facetSpecArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (FacetSpec facetSpec : facetSpecArray) {
            PropertySpec propertySpec = facetSpec.propSpec;
            if (propertySpec == null) continue;
            String string = propertySpec.providerType;
            for (String string2 : propertySpec.properties) {
                RelationDescriptor[] relationDescriptorArray;
                ValidationUtil.stringsNotNullOrEmpty((String[])new String[]{string2});
                if (propertySpec.relationship != null && !propertySpec.relationship.isEmpty()) {
                    relationDescriptorArray = MetadataUtil.getRelationshipHops(this._metadataDirectory, propertySpec.providerType, propertySpec.relationship);
                    if (!MetadataUtil.isRelationshipSupported(relationDescriptorArray)) continue;
                    RelationDescriptor relationDescriptor = relationDescriptorArray[relationDescriptorArray.length - 1];
                    string = MetadataUtil.getTargetType(relationDescriptor, this._metadataDirectory);
                }
                if (!MetadataUtil.isSupported((Descriptor)(relationDescriptorArray = this._metadataDirectory.getPropertyDescriptor(string2, string)))) continue;
                stringBuilder.append(this.createDynFacetExpr(facetSpec, string2)).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    private String createDynFacetExpr(FacetSpec facetSpec, String string) {
        PropertySpec propertySpec = facetSpec.propSpec;
        PropertySpecExprBuilder propertySpecExprBuilder = this.createPropSpecExprBuilderForProperty(propertySpec, string);
        String string2 = propertySpecExprBuilder.getSetExprString();
        String string3 = propertySpecExprBuilder.getProviderTypeFor(propertySpec);
        String string4 = propertySpecExprBuilder.getProviderIdFor(propertySpec);
        String string5 = this.getFacetPropertyExpr(string3, string, string4);
        String string6 = this.constructFacetName(propertySpec.providerType, propertySpec.relationship, string);
        String string7 = string2 + "\n" + "let $facetVals := " + string5 + "\n" + "let $facets := ($facets, local:computeFacetForPropery(\"" + string6 + "\", \"" + XMLUtil.escapeXmlTag((String)string) + "\", $facetVals" + "))\n";
        return string7;
    }

    private PropertySpecExprBuilder createPropSpecExprBuilderForProperty(PropertySpec propertySpec, String string) {
        PropertySpec propertySpec2 = new PropertySpec();
        propertySpec2.providerType = propertySpec.providerType;
        propertySpec2.relationship = propertySpec.relationship;
        propertySpec2.properties = new String[]{string};
        PropertySpecExprBuilder propertySpecExprBuilder = new PropertySpecExprBuilder(new PropertySpec[]{propertySpec2}, "targetSet", false, this._metadataDirectory, this._rendererFactory);
        return propertySpecExprBuilder;
    }

    private String getFacetPropertyExpr(String string, String string2, String string3) {
        PropertyDescriptor propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string2, string);
        String string4 = MetadataUtil.getQueryExpression(propertyDescriptor, QueryContextType.CONTEXT_BOUNDED);
        string4 = XQueryUtils.toQualifiedXPath(string3, string4);
        return string4;
    }

    private String constructFacetName(String string, String string2, String string3) {
        String string4 = this.ifNullReturnEmptyStrElseValue(string) + "::" + this.ifNullReturnEmptyStrElseValue(string2) + "::" + string3;
        return string4;
    }

    private String ifNullReturnEmptyStrElseValue(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

