/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.PropertySpec;
import com.vmware.vise.search.impl.SearchUtil;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.transform.Transformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SearchPropertiesSpecTransformer
implements Transformer<PropertySpec[]> {
    private final MetadataDirectory _metadataDirectory;

    SearchPropertiesSpecTransformer(MetadataDirectory metadataDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataDirectory});
        this._metadataDirectory = metadataDirectory;
    }

    public Transformer.Result<PropertySpec[]> transform(PropertySpec[] propertySpecArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])propertySpecArray)) {
            return new Transformer.Result((Object)propertySpecArray);
        }
        Collection<TypeDescriptor> collection = MetadataUtil.getSearchableTypes(this._metadataDirectory);
        if (collection.isEmpty()) {
            return new Transformer.Result((Object)propertySpecArray);
        }
        PropertySpec[] propertySpecArray2 = this.convertPropertySpecs(propertySpecArray, collection);
        return new Transformer.Result((Object)propertySpecArray2, true);
    }

    private PropertySpec newPropertySpec(String string, String string2, String[] stringArray) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.providerType = string;
        propertySpec.relationship = string2;
        propertySpec.properties = stringArray;
        return propertySpec;
    }

    private PropertySpec[] convertPropertySpecs(PropertySpec[] propertySpecArray, Collection<TypeDescriptor> collection) {
        HashMap<Pair<String, String>, List<PropertySpec>> hashMap = new HashMap<Pair<String, String>, List<PropertySpec>>();
        for (PropertySpec propertySpec : propertySpecArray) {
            if (SearchUtil.representsAllTypes(propertySpec.providerType)) {
                PropertySpec[] propertySpecArray2 = this.convertPropertySpec(propertySpec, collection);
                SearchPropertiesSpecTransformer.addAllPropertySpec(hashMap, propertySpecArray2);
                continue;
            }
            SearchPropertiesSpecTransformer.addPropertySpec(hashMap, propertySpec);
        }
        List<PropertySpec> list = this.mergePropertySpecs(hashMap);
        PropertySpec[] propertySpecArray3 = list.toArray(new PropertySpec[list.size()]);
        return propertySpecArray3;
    }

    private List<PropertySpec> mergePropertySpecs(Map<Pair<String, String>, List<PropertySpec>> map) {
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>(map.keySet().size());
        for (Pair<String, String> pair : map.keySet()) {
            List<PropertySpec> list = map.get(pair);
            PropertySpec propertySpec = this.mergeProperties((String)pair.first, (String)pair.second, list);
            if (propertySpec == null) continue;
            arrayList.add(propertySpec);
        }
        return arrayList;
    }

    private PropertySpec mergeProperties(String string, String string2, List<PropertySpec> list) {
        if (ArrayUtil.isNullOrEmpty(list)) {
            return null;
        }
        Set<String> set = this.getProperties(list);
        PropertySpec propertySpec = this.newPropertySpec(string, string2, set.toArray(new String[set.size()]));
        return propertySpec;
    }

    private Set<String> getProperties(List<PropertySpec> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertySpec propertySpec : list) {
            for (String string : propertySpec.properties) {
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private PropertySpec[] convertPropertySpec(PropertySpec propertySpec, Collection<TypeDescriptor> collection) {
        PropertySpec[] propertySpecArray = new PropertySpec[collection.size()];
        int n = 0;
        for (TypeDescriptor typeDescriptor : collection) {
            PropertySpec propertySpec2 = this.getPropertySpec(typeDescriptor, propertySpec.properties);
            propertySpecArray[n++] = propertySpec2;
        }
        return propertySpecArray;
    }

    private PropertySpec getPropertySpec(TypeDescriptor typeDescriptor, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (SearchUtil.representsAllProperties(string)) {
                List<PropertyDescriptor> list = this._metadataDirectory.getPropertyDescriptors(typeDescriptor.getType());
                List<String> list2 = SearchPropertiesSpecTransformer.getPropertiesFromPropertyDescriptors(list);
                arrayList.addAll(list2);
                continue;
            }
            arrayList.add(string);
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        PropertySpec propertySpec = this.newPropertySpec(typeDescriptor.getType(), null, stringArray2);
        return propertySpec;
    }

    private static List<String> getPropertiesFromPropertyDescriptors(List<PropertyDescriptor> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (PropertyDescriptor propertyDescriptor : list) {
            arrayList.add(propertyDescriptor.getName());
        }
        return arrayList;
    }

    private static void addPropertySpec(Map<Pair<String, String>, List<PropertySpec>> map, PropertySpec propertySpec) {
        Pair pair = new Pair((Object)propertySpec.providerType, (Object)propertySpec.relationship);
        List<PropertySpec> list = map.get(pair);
        if (list == null) {
            list = new ArrayList<PropertySpec>();
            map.put((Pair<String, String>)pair, list);
        }
        list.add(propertySpec);
    }

    private static void addAllPropertySpec(Map<Pair<String, String>, List<PropertySpec>> map, PropertySpec[] propertySpecArray) {
        for (PropertySpec propertySpec : propertySpecArray) {
            SearchPropertiesSpecTransformer.addPropertySpec(map, propertySpec);
        }
    }
}

