/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.metadata.ObjectModelProvider;
import com.vmware.vise.search.TypeRef;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.util.Directory;
import com.vmware.vise.util.ValidationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

final class TypeRefDirectoryImpl
implements TypeRefDirectory {
    private final Map<String, TypeRef> _typeRefCache;
    private final int CACHE_MAX_ENTRIES = 1000;
    private final float CACHE_LOAD_FACTOR = 0.75f;
    private final boolean CACHE_ACCESS_ORDER = true;
    private final Directory<ObjectModelProvider> _providerDirectory;

    TypeRefDirectoryImpl(Directory<ObjectModelProvider> directory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{directory});
        LinkedHashMap<String, TypeRef> linkedHashMap = new LinkedHashMap<String, TypeRef>(1000, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, TypeRef> entry) {
                return this.size() > 1000;
            }
        };
        Collection<TypeRef> collection = TypeRefUtils.getPrimitiveTypes();
        for (TypeRef typeRef : collection) {
            linkedHashMap.put(typeRef.getName(), typeRef);
        }
        this._typeRefCache = Collections.synchronizedMap(linkedHashMap);
        this._providerDirectory = directory;
    }

    @Override
    public TypeRef getTypeRef(String string) {
        if (string == null) {
            return null;
        }
        String string2 = NamespaceUtils.getNamespace(string);
        ObjectModelProvider objectModelProvider = (ObjectModelProvider)this._providerDirectory.get(string2);
        TypeRef typeRef = TypeRefDirectoryImpl.getInstance(string, this._typeRefCache, objectModelProvider);
        if (typeRef != null) {
            return typeRef;
        }
        return TypeRefUtils.ROOT_TYPEREF;
    }

    private static TypeRef getInstance(String string, Map<String, TypeRef> map, ObjectModelProvider objectModelProvider) {
        assert (string != null);
        assert (map != null);
        assert (objectModelProvider != null);
        TypeRef typeRef = map.get(string);
        if (typeRef != null) {
            return typeRef;
        }
        typeRef = new TypeRef(string, objectModelProvider);
        map.put(string, typeRef);
        return typeRef;
    }
}

