/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.search.PropertyInfo;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.xml.XmlStreamUtils;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UnmarshallingUtil {
    private static Log _logger = LogFactory.getLog(UnmarshallingUtil.class);
    private static final String REDIRECT_ATTRIB_NAME = "xlink:href";

    public static boolean isReferenceProperty(XMLStreamReader xMLStreamReader) {
        assert (xMLStreamReader != null);
        boolean bl = !Strings.isNullOrEmpty(XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (String)REDIRECT_ATTRIB_NAME));
        return bl;
    }

    public static Object processReferenceProperty(XMLStreamReader xMLStreamReader, PropertyInfo propertyInfo) throws XMLStreamException {
        assert (xMLStreamReader != null);
        assert (propertyInfo != null);
        Object object = null;
        try {
            int n = xMLStreamReader.getEventType();
            if (n == 1) {
                String string = XmlStreamUtils.getAttributeValue((XMLStreamReader)xMLStreamReader, (String)REDIRECT_ATTRIB_NAME);
                xMLStreamReader.getElementText();
                object = QueryUtil.getReference((String)string);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            String string = propertyInfo.getName();
            String string2 = "";
            if (propertyInfo.getProvider() != null) {
                string2 = propertyInfo.getProvider();
            }
            String string3 = String.format("Error with reference property: (providerType=%1$s, propertyName=%2$s).", string2, string);
            _logger.error((Object)string3, (Throwable)xMLStreamException);
            throw xMLStreamException;
        }
        return object;
    }

    public static void moveReaderUntilStartOrEndElement(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{xMLStreamReader});
        xMLStreamReader.next();
        while (!xMLStreamReader.isStartElement() && !xMLStreamReader.isEndElement() && xMLStreamReader.hasNext()) {
            xMLStreamReader.next();
        }
    }
}

