/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.DataObjectType;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.Util;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vise.search.PropertyInfo;
import com.vmware.vise.search.PropertyUnmarshaller;
import com.vmware.vise.search.ValueEx;
import com.vmware.vise.search.impl.UnmarshallingUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.xml.NamespaceUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VmodlPropertyUnmarshaller
implements PropertyUnmarshaller {
    private static final Logger _logger = LoggerFactory.getLogger(VmodlPropertyUnmarshaller.class);
    private final VmodlTypeMap _typeMap;
    private final ConcurrentHashMap<String, VmodlType> _cache;
    private final Unmarshaller _unmarshaller;
    private static final String TYPED_PROPERTY = "@type";
    private static final Pattern EXTRACT_TYPED_PROPERTY_PATTERN = Pattern.compile(".+\\[@type=['\"](\\w+)['\"]\\]");
    private static final AtomicBoolean _vmodlTypeMapContentsHaveBeenLogged = new AtomicBoolean(false);

    public VmodlPropertyUnmarshaller(Unmarshaller unmarshaller) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{unmarshaller});
        this._typeMap = VmodlTypeMap.Factory.getTypeMap();
        this._cache = new ConcurrentHashMap();
        this._unmarshaller = unmarshaller;
    }

    @Override
    public ValueEx<Object> getValue(PropertyInfo propertyInfo, XMLStreamReader xMLStreamReader) throws XMLStreamException {
        VmodlType vmodlType;
        String string = XMLUtil.unescapeXmlTag((String)xMLStreamReader.getLocalName());
        String string2 = propertyInfo.getProvider();
        if (string2 == null) {
            return new ValueEx<Object>(null);
        }
        String string3 = this.getPropertyPath(propertyInfo);
        if (string3 == null) {
            return new ValueEx<Object>(null);
        }
        try {
            vmodlType = this.getDeclaredType(string2, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.warn("Cannot compute type for property `{}': {}. Property skipped by the unmarshaller.", (Object)string, (Object)illegalArgumentException.getMessage());
            _logger.debug("", (Throwable)illegalArgumentException);
            UnmarshallingUtil.moveReaderUntilStartOrEndElement(xMLStreamReader);
            return new ValueEx<Object>(null);
        }
        Class clazz = null;
        try {
            int n = xMLStreamReader.getEventType();
            if (n == 1) {
                List<Object> list = this.deserializeVmodlField(xMLStreamReader, vmodlType);
                Object object = this.convertListToValue(list, propertyInfo);
                VmodlType vmodlType2 = this.determineVmodlType(string2);
                if (vmodlType2 != null) {
                    clazz = vmodlType2.getTypeClass();
                }
                Object object2 = this.getFormattedValue(object, vmodlType2, string2, string);
                return new ValueEx<Object>(object2, clazz);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            _logger.error(this.formatErrorMsg(string2, string), (Throwable)xMLStreamException);
            throw xMLStreamException;
        }
        catch (UnmarshallException unmarshallException) {
            _logger.error(this.formatErrorMsg(string2, string), (Throwable)unmarshallException);
            return new ValueEx<Object>(null, clazz, (Exception)((Object)unmarshallException));
        }
        return null;
    }

    private Class<?> getVMODLClassType(PropertyInfo propertyInfo) {
        Class clazz = null;
        String string = propertyInfo.getType();
        if (string != null) {
            try {
                clazz = Class.forName(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                _logger.debug("Property type `{}' for `{}' is not a Java class type, falling back to VmodlTypeMap ({}: {})", new Object[]{string, propertyInfo.getName(), classNotFoundException.getClass().getName(), classNotFoundException.getMessage()});
            }
        }
        String string2 = propertyInfo.getProvider();
        String string3 = this.getPropertyPath(propertyInfo);
        VmodlType vmodlType = this.getDeclaredType(string2, string3);
        clazz = vmodlType.getTypeClass();
        if (vmodlType instanceof VmodlArrayType) {
            clazz = ((VmodlArrayType)vmodlType).getComponentType().getTypeClass();
        }
        return clazz;
    }

    private Object convertListToValue(List<?> list, PropertyInfo propertyInfo) {
        assert (list != null);
        assert (propertyInfo != null);
        Object object = null;
        if (list.size() > 0 && !propertyInfo.isMultiCardinality()) {
            Object obj = list.get(0);
            return obj;
        }
        if (list.size() >= 1 && list.get(0) instanceof Object[]) {
            assert (list.size() == 1);
            object = list.get(0);
        } else {
            Class<?> clazz = this.getVMODLClassType(propertyInfo);
            object = ArrayUtil.toTypedArray(list, clazz);
        }
        if (ArrayUtil.isNullOrEmpty((Object[])object)) {
            return null;
        }
        return object;
    }

    private VmodlType determineVmodlType(String string) {
        String string2 = NamespaceUtil.getUnqualifiedTypeName((String)string);
        VmodlType vmodlType = this._typeMap.getVmodlType(string2);
        return vmodlType;
    }

    private Object getFormattedValue(Object object, VmodlType vmodlType, String string, String string2) {
        if (vmodlType == null) {
            return null;
        }
        Class clazz = vmodlType.getTypeClass();
        if (object instanceof String && ManagedEntity.class.isAssignableFrom(clazz) && "name".equals(string2)) {
            String string3 = MixedUtil.unescapeVimEntityNameSpecialChars((String)((String)object));
            return string3;
        }
        if (object instanceof String && "DistributedVirtualPortgroup".equals(string) && "config.name".equals(string2)) {
            String string4 = MixedUtil.unescapeVimEntityNameSpecialChars((String)((String)object));
            return string4;
        }
        if (object instanceof String && "VirtualMachine".equals(string) && "config.name".equals(string2)) {
            String string5 = MixedUtil.unescapeVimEntityNameSpecialChars((String)((String)object));
            return string5;
        }
        if (object instanceof DistributedVirtualPortgroup.ConfigInfo) {
            DistributedVirtualPortgroup.ConfigInfo configInfo = (DistributedVirtualPortgroup.ConfigInfo)object;
            configInfo.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)configInfo.name);
            return object;
        }
        if (object instanceof ConfigInfo) {
            ConfigInfo configInfo = (ConfigInfo)object;
            configInfo.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)configInfo.name);
            return object;
        }
        return object;
    }

    private String formatErrorMsg(String string, String string2) {
        return String.format("Error in reading vmodl property: (providerType=%1$s, propertyName=%2$s).", string, string2);
    }

    private List<Object> deserializeVmodlField(XMLStreamReader xMLStreamReader, VmodlType vmodlType) throws XMLStreamException, UnmarshallException {
        int n = xMLStreamReader.getEventType();
        if (n != 1) {
            xMLStreamReader.nextTag();
        }
        String string = xMLStreamReader.getLocalName();
        try {
            VmodlProperty vmodlProperty = new VmodlProperty(string, vmodlType);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string2 = null;
            do {
                Object object = this._unmarshaller.unmarshal((VmodlField)vmodlProperty, xMLStreamReader);
                arrayList.add(object);
                string2 = null;
                if (!xMLStreamReader.hasNext()) continue;
                if (xMLStreamReader.getEventType() == 2 && string.equals(xMLStreamReader.getLocalName())) {
                    UnmarshallingUtil.moveReaderUntilStartOrEndElement(xMLStreamReader);
                }
                if (!xMLStreamReader.isStartElement()) continue;
                string2 = xMLStreamReader.getLocalName();
            } while (string.equals(string2));
            return arrayList;
        }
        catch (UnmarshallException unmarshallException) {
            if (xMLStreamReader.hasNext()) {
                xMLStreamReader.next();
            }
            throw unmarshallException;
        }
    }

    private VmodlType getDeclaredType(String string, String string2) {
        String string3 = NamespaceUtil.getUnqualifiedTypeName((String)string);
        String string4 = string3 + '.' + string2;
        if (this._cache.contains(string4)) {
            return this._cache.get(string4);
        }
        VmodlType vmodlType = this._typeMap.getVmodlType(string3);
        if (vmodlType == null) {
            throw new IllegalArgumentException(String.format("Provider type `%s' for property `%s' not found in the VMODL type map", string3, string2));
        }
        String[] stringArray = string2.split("\\.|/");
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException(string2);
        }
        String string5 = this.getTypeFromPredicatedPropPath(stringArray[0]);
        VmodlType vmodlType2 = this.computePropertyType(vmodlType, stringArray[0], string5);
        for (int i = 1; i < stringArray.length; ++i) {
            String string6;
            Object object;
            if (vmodlType2 instanceof VmodlArrayType) {
                vmodlType2 = ((VmodlArrayType)vmodlType2).getComponentType();
            }
            if (!(vmodlType2 instanceof ComplexType)) {
                object = new StringBuilder(300);
                ((StringBuilder)object).append(string2).append(": Error in property '").append(stringArray[i - 1]).append("' -- ");
                if (vmodlType2 != null) {
                    ((StringBuilder)object).append("type '").append(vmodlType2.toString()).append("' is not a complex type. The actual type is '").append(vmodlType2.getClass().getName()).append("'");
                } else {
                    ((StringBuilder)object).append("the type is unknown, but it had to be a complex type");
                }
                string6 = ((StringBuilder)object).toString();
                _logger.error(string6);
                throw new IllegalArgumentException(string6);
            }
            object = (ComplexType)vmodlType2;
            string6 = this.getTypeFromPredicatedPropPath(stringArray[i]);
            vmodlType2 = this.computePropertyType((VmodlType)object, stringArray[i], string6);
        }
        if (vmodlType2 == null) {
            vmodlType2 = this._typeMap.getVmodlType(Object.class);
        }
        this._cache.put(string4, vmodlType2);
        return vmodlType2;
    }

    private VmodlType computePropertyType(VmodlType vmodlType, String string, String string2) {
        VmodlType vmodlType2 = null;
        if (string2 != null) {
            vmodlType2 = this._typeMap.getVmodlType(string2);
            if (vmodlType2 == null) {
                String string3 = "There's no registered VMODL type with WSDL name: " + string2;
                _logger.error(string3);
            } else {
                this.logIfThereIsMismatchBetweenPropertyTypeAndVmodlType(vmodlType2, string2);
            }
        } else {
            Object object;
            ManagedProperty managedProperty = null;
            if (vmodlType instanceof ManagedObjectType) {
                object = (ManagedObjectType)vmodlType;
                managedProperty = object.getManagedProperty(string);
            } else if (vmodlType instanceof DataObjectType) {
                object = (DataObjectType)vmodlType;
                managedProperty = object.getProperty(string);
            } else {
                String string4 = String.format("Property path descends into a non-structural type `%s' at `%s'", vmodlType.toString(), string);
                throw new IllegalArgumentException(string4);
            }
            if (managedProperty == null) {
                object = String.format("Segment `%s' doesn't belong to the parent provider with type `%s'", string, vmodlType.toString());
                vmodlType2 = this.workaroundWhenPropertyDoesNotBelongToProvider(vmodlType, string, (String)object);
                if (vmodlType2 != null) {
                    return vmodlType2;
                }
                throw new IllegalArgumentException((String)object);
            }
            vmodlType2 = managedProperty.getType();
            if (vmodlType2 == null) {
                _logger.error("The type of field '" + managedProperty.getName() + "' cannot be determined.");
            }
        }
        return vmodlType2;
    }

    private void logIfThereIsMismatchBetweenPropertyTypeAndVmodlType(VmodlType vmodlType, String string) {
        if (!string.equals(vmodlType.getWsdlName())) {
            _logger.error("VMODL returned an unexpected type. Returned: " + vmodlType.getWsdlName() + " (" + vmodlType.getTypeClass() + "). Expected: " + string);
            boolean bl = _vmodlTypeMapContentsHaveBeenLogged.compareAndSet(false, true);
            if (bl) {
                this.logContentsOfVmodlTypeMap();
            }
        }
    }

    private VmodlType workaroundWhenPropertyDoesNotBelongToProvider(VmodlType vmodlType, String string, String string2) {
        VmodlType vmodlType2 = null;
        if ("uplinkPortName".equals(string) && ("DVSNameArrayUplinkPortPolicy".equals(vmodlType.getWsdlName()) || "DVSUplinkPortPolicy".equals(vmodlType.getWsdlName()))) {
            _logger.error(string2);
            vmodlType2 = this._typeMap.getVmodlType(String[].class);
            if (vmodlType2 == null) {
                _logger.error("VMODL can't produce a VmodlType for String[]");
            }
        }
        return vmodlType2;
    }

    private void logContentsOfVmodlTypeMap() {
        try {
            Field field = this._typeMap.getClass().getDeclaredField("_wsdlTypeMap");
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            Map map = (Map)field.get(this._typeMap);
            field.setAccessible(bl);
            StringBuilder stringBuilder = new StringBuilder(20000);
            HashSet hashSet = new HashSet(map.entrySet());
            for (Map.Entry entry : hashSet) {
                String string = (String)entry.getKey();
                VmodlType vmodlType = (VmodlType)entry.getValue();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append("WSDL name: ").append(string).append(", Type: ").append(vmodlType != null ? vmodlType.getTypeClass() : "[null]");
            }
            _logger.error("VmodlTypeMap contents:\n" + stringBuilder.toString());
        }
        catch (Exception exception) {
            _logger.error("Unable to extract the VmodlTypeMap contents");
        }
    }

    private String getTypeFromPredicatedPropPath(String string) {
        if (string.contains(TYPED_PROPERTY)) {
            Matcher matcher = EXTRACT_TYPED_PROPERTY_PATTERN.matcher(string);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new IllegalArgumentException(string + " doesn't meet the requirements " + "for a typed predicate. The expectation is a string " + "of the form config[@type='VMwareDVSConfigInfo'].");
        }
        return null;
    }

    private String getPropertyPath(PropertyInfo propertyInfo) {
        if (propertyInfo == null) {
            return null;
        }
        String string = null;
        if (!(propertyInfo instanceof PropertyDescriptor)) {
            throw new IllegalStateException("Expected PropertyDescriptor type.");
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyInfo;
        if (!propertyDescriptor.isComputed()) {
            string = propertyDescriptor.getPath();
            if (!Strings.isNullOrEmpty(string)) {
                return string;
            }
            string = propertyInfo.getSimpleName();
        }
        return string;
    }

    private static class VmodlProperty
    implements VmodlField {
        private String _name;
        private VmodlType _type;
        private VmodlField.CollectionType _collectionType;

        public VmodlProperty(String string, VmodlType vmodlType) {
            this._name = string;
            this._type = vmodlType;
        }

        public String getName() {
            return this._name;
        }

        public String getWsdlName() {
            return this._name;
        }

        public VmodlType getType() {
            return this._type;
        }

        public VmodlType getLinkType() {
            return this._type;
        }

        public VmodlVersion getVersion() {
            return this._type.getVersion();
        }

        public String GetPrivilegeId() {
            return null;
        }

        public boolean isOptional() {
            return false;
        }

        public boolean isLink() {
            return false;
        }

        public boolean isLinkable() {
            return false;
        }

        public boolean isVisible(VmodlVersion vmodlVersion) {
            return this._type.IsVisible(vmodlVersion);
        }

        public VmodlType getManagedObjectType() {
            return this._type;
        }

        public boolean isSecret() {
            return false;
        }

        public VmodlField.CollectionType getCollectionType() {
            if (this._collectionType == null) {
                Annotation[] annotationArray = this.getClass().getAnnotations();
                HashMap hashMap = Util.mapAnnotations((Annotation[])annotationArray);
                this._collectionType = Util.computeCollectionType((Map)hashMap);
            }
            return this._collectionType;
        }
    }
}

