/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.TypeRef;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.metadata.DescriptorSource;
import com.vmware.vise.search.metadata.DescriptorSourceImpl;
import com.vmware.vise.search.metadata.DirectoryContainer;
import com.vmware.vise.search.metadata.FunctionDescriptor;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataEvent;
import com.vmware.vise.search.metadata.MetadataListener;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.PropertyDescriptorDirectory;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.search.metadata.TypeDescriptorImpl;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class MetadataDirectoryImpl
implements MetadataDirectory {
    private static final Log _logger = LogFactory.getLog(MetadataDirectoryImpl.class);
    private final CopyOnWriteArrayList<MetadataListener> _listeners = new CopyOnWriteArrayList();
    private final TypeRefDirectory _typeRefDirectory;
    private final CopyOnWriteArraySet<String> _reservedDescriptorSourceIds = new CopyOnWriteArraySet();
    private final Object _searchMetadataLock = new Object();
    private volatile DirectoryContainer _directoryContainer;
    private final LinkedHashMap<String, DescriptorSource> _descriptorSourceById = new LinkedHashMap();

    MetadataDirectoryImpl(TypeRefDirectory typeRefDirectory, DirectoryContainer directoryContainer) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeRefDirectory, directoryContainer});
        this._typeRefDirectory = typeRefDirectory;
        this._directoryContainer = directoryContainer;
    }

    @Override
    public List<TypeDescriptor> getAllTypeDescriptors() {
        List<TypeDescriptor> list = this._directoryContainer.getTypeDirectory().getAllTypeDescriptors();
        return list;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String string) {
        TypeDescriptor typeDescriptor = this._directoryContainer.getTypeDirectory().getTypeDescriptor(string);
        return typeDescriptor;
    }

    @Override
    public boolean hasDescriptor(String string) {
        boolean bl = this._directoryContainer.getTypeDirectory().hasDescriptor(string);
        return bl;
    }

    @Override
    public List<PropertyDescriptor> getPropertyDescriptors(String string) {
        List<PropertyDescriptor> list = this._directoryContainer.getPropertyDirectory().getPropertyDescriptors(string);
        return list;
    }

    @Override
    public boolean hasPreDefinedDescriptor(String string, String string2) {
        boolean bl = this._directoryContainer.getPropertyDirectory().hasPreDefinedDescriptor(string, string2);
        return bl;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String string, String string2) {
        return this.getPropertyDescriptor(string, string2, null);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String string, String string2, String string3) {
        PropertyDescriptorDirectory propertyDescriptorDirectory = this._directoryContainer.getPropertyDirectory();
        PropertyDescriptor propertyDescriptor = propertyDescriptorDirectory.getPropertyDescriptor(string, string2, string3);
        return propertyDescriptor;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptorIfComputed(String string, String string2) {
        PropertyDescriptorDirectory propertyDescriptorDirectory = this._directoryContainer.getPropertyDirectory();
        PropertyDescriptor propertyDescriptor = propertyDescriptorDirectory.getPropertyDescriptor(string, string2);
        if (propertyDescriptor.isComputed()) {
            return propertyDescriptor;
        }
        return null;
    }

    @Override
    public List<PropertyDescriptor> getTextualPropertyDescriptors(String string) {
        PropertyDescriptorDirectory propertyDescriptorDirectory = this._directoryContainer.getPropertyDirectory();
        List<PropertyDescriptor> list = propertyDescriptorDirectory.getTextualPropertyDescriptors(string);
        return list;
    }

    @Override
    public void setQueryExpression(PropertyDescriptor propertyDescriptor, String string) {
        this._directoryContainer.getPropertyDirectory().setQueryExpression(propertyDescriptor, string);
    }

    @Override
    public RelationDescriptor getRelationDescriptor(PropertyDescriptor propertyDescriptor) {
        RelationDescriptor relationDescriptor = this._directoryContainer.getRelationDirectory().getRelationDescriptor(propertyDescriptor);
        return relationDescriptor;
    }

    @Override
    public RelationDescriptor getRelationDescriptor(String string) {
        RelationDescriptor relationDescriptor = this._directoryContainer.getRelationDirectory().getRelationDescriptor(string);
        return relationDescriptor;
    }

    @Override
    public FunctionDescriptor getFunctionDescriptor(String string) {
        FunctionDescriptor functionDescriptor = this._directoryContainer.getFunctionDirectory().getFunctionDescriptor(string);
        return functionDescriptor;
    }

    @Override
    public void addSource(DescriptorSource descriptorSource) {
        this.addSourceInternal(descriptorSource);
    }

    @Override
    public void addReservedSource(DescriptorSource descriptorSource) {
        this.addSourceInternal(descriptorSource);
        this._reservedDescriptorSourceIds.add(descriptorSource.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSource(String string) {
        if (string == null) {
            return;
        }
        if (this._reservedDescriptorSourceIds.contains(string)) {
            throw new IllegalStateException("Cannot unregister reserved metadata sourceId: " + string);
        }
        Object object = this._searchMetadataLock;
        synchronized (object) {
            DescriptorSource descriptorSource = (DescriptorSource)this._descriptorSourceById.remove(string);
            if (descriptorSource == null) {
                return;
            }
            this._directoryContainer.clear();
            for (DescriptorSource descriptorSource2 : this._descriptorSourceById.values()) {
                this._directoryContainer.addSource(descriptorSource2);
            }
        }
    }

    @Override
    public void addListener(MetadataListener metadataListener) {
        if (metadataListener != null) {
            this._listeners.add(metadataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DescriptorSource> getDescriptorSources() {
        Object object = this._searchMetadataLock;
        synchronized (object) {
            ArrayList<DescriptorSource> arrayList = new ArrayList<DescriptorSource>(this._descriptorSourceById.values());
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSourceInternal(DescriptorSource descriptorSource) {
        if (descriptorSource == null) {
            return;
        }
        if (descriptorSource.getId() == null) {
            throw new IllegalArgumentException("source id cannot be null");
        }
        DescriptorSource descriptorSource2 = this.transformSource(descriptorSource);
        Object object = this._searchMetadataLock;
        synchronized (object) {
            if (this._descriptorSourceById.containsKey(descriptorSource2.getId()) && this._reservedDescriptorSourceIds.contains(descriptorSource2.getId())) {
                throw new IllegalStateException("Cannot reregister reserved metadata.");
            }
            if (!this._reservedDescriptorSourceIds.contains(descriptorSource2.getId())) {
                this.removeSource(descriptorSource2.getId());
            }
            this._descriptorSourceById.put(descriptorSource2.getId(), descriptorSource2);
            this._directoryContainer.addSource(descriptorSource2);
        }
        if (_logger.isDebugEnabled()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Adding search metadata\n");
            ((StringBuilder)object).append("Number of types added: " + descriptorSource2.getTypes().size() + "\n");
            ((StringBuilder)object).append("Number of properties added: " + descriptorSource2.getProperties().size() + "\n");
            ((StringBuilder)object).append("Number of relations added: " + descriptorSource2.getTypeRelationships().size());
            _logger.debug((Object)((StringBuilder)object).toString());
        }
        object = new MetadataEvent(descriptorSource2);
        for (MetadataListener metadataListener : this._listeners) {
            metadataListener.handleEvent((MetadataEvent)object);
        }
    }

    private DescriptorSource transformSource(DescriptorSource descriptorSource) {
        assert (descriptorSource != null);
        ArrayList<TypeDescriptor> arrayList = new ArrayList<TypeDescriptor>(descriptorSource.getTypes().size());
        for (TypeDescriptor typeDescriptor : descriptorSource.getTypes()) {
            TypeRef typeRef = this._typeRefDirectory.getTypeRef(typeDescriptor.getType());
            String string = typeRef.getImmediateSuperType();
            if (string != null) {
                arrayList.add(new TypeDescriptorImpl(typeDescriptor, string));
                continue;
            }
            arrayList.add(typeDescriptor);
        }
        DescriptorSourceImpl descriptorSourceImpl = new DescriptorSourceImpl(descriptorSource.getId(), arrayList, descriptorSource.getProperties(), descriptorSource.getTypeRelationships(), descriptorSource.getLocalFunctions(), descriptorSource.getResourceClassLoader(), descriptorSource.getResourceBundleName());
        return descriptorSourceImpl;
    }
}

