/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.metadata.Units;
import com.vmware.vise.search.QueryExprInfo;
import com.vmware.vise.search.TypeRef;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.metadata.DescriptorData;
import com.vmware.vise.search.metadata.DescriptorDirectoryStoreAccess;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.PropertyDescriptorDirectory;
import com.vmware.vise.search.metadata.PropertyDescriptorImpl;
import com.vmware.vise.search.metadata.PropertyDescriptorOption;
import com.vmware.vise.search.metadata.Restriction;
import com.vmware.vise.search.util.KeyValuePair;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class PropertyDescriptorDirectoryImpl
implements PropertyDescriptorDirectory,
DescriptorDirectoryStoreAccess<PropertyDescriptor> {
    private static final Log _logger = LogFactory.getLog(PropertyDescriptorDirectoryImpl.class);
    private final TypeRefDirectory _typeRefDirectory;
    private final ConcurrentMap<KeyValuePair<String, String>, DescriptorData<PropertyDescriptor>> _builtInProps = new ConcurrentHashMap<KeyValuePair<String, String>, DescriptorData<PropertyDescriptor>>();
    private final ConcurrentMap<KeyValuePair<String, String>, DescriptorData<PropertyDescriptor>> _predefinedProps = new ConcurrentHashMap<KeyValuePair<String, String>, DescriptorData<PropertyDescriptor>>();
    private final ConcurrentMap<KeyValuePair<String, String>, PropertyDescriptor> _autogenProps = new ConcurrentHashMap<KeyValuePair<String, String>, PropertyDescriptor>();
    private final ConcurrentMap<TypeRef, List<DescriptorData<PropertyDescriptor>>> _textualPropsByType = new ConcurrentHashMap<TypeRef, List<DescriptorData<PropertyDescriptor>>>(6);

    PropertyDescriptorDirectoryImpl(TypeRefDirectory typeRefDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeRefDirectory});
        this._typeRefDirectory = typeRefDirectory;
    }

    @Override
    public boolean hasPreDefinedDescriptor(String string, String string2) {
        if (Strings.isNullOrEmpty(string2)) {
            throw new IllegalArgumentException("Property name has to be specified.");
        }
        if (string == null) {
            string = TypeRefUtils.ROOT_TYPEREF.getName();
        }
        KeyValuePair<String, String> keyValuePair = new KeyValuePair<String, String>(string, string2);
        KeyValuePair<String, String> keyValuePair2 = PropertyDescriptorDirectoryImpl.makeBuiltInPropKey(string2);
        return this._predefinedProps.containsKey(keyValuePair) || this._builtInProps.containsKey(keyValuePair2);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String string, String string2) {
        return this.getPropertyDescriptor(string, string2, null);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String string, String string2, String string3) {
        PropertyDescriptor propertyDescriptor;
        if (Strings.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("Name of the property has to be specified.");
        }
        if (string2 == null) {
            string2 = TypeRefUtils.ROOT_TYPEREF.getName();
        }
        if ((propertyDescriptor = this.getPropertyDescriptorFromCache(string2, string, true)) == null) {
            TypeRef typeRef = this._typeRefDirectory.getTypeRef(string2);
            propertyDescriptor = this.getPropertyFromSupertype(typeRef, string);
        }
        if (propertyDescriptor != null) {
            boolean bl;
            propertyDescriptor = this.transformPropertyDescriptorByNameMetadataIfNeeded(propertyDescriptor, string2, string);
            boolean bl2 = string3 == null ? propertyDescriptor.getProviderResourceModelCanonicalName() == null : (bl = string3.equals(propertyDescriptor.getProviderResourceModelCanonicalName()));
            if (!bl) {
                propertyDescriptor = new PropertyDescriptorWrapper(propertyDescriptor, string3);
            }
        } else {
            propertyDescriptor = this.newPropertyDescriptor(string2, string, string3);
        }
        return propertyDescriptor;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptorIfComputed(String string, String string2) {
        PropertyDescriptor propertyDescriptor;
        KeyValuePair<String, String> keyValuePair;
        DescriptorData descriptorData;
        if (Strings.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("Name of the property has to be specified.");
        }
        if (string2 == null) {
            string2 = TypeRefUtils.ROOT_TYPEREF.getName();
        }
        if ((descriptorData = (DescriptorData)this._predefinedProps.get(keyValuePair = new KeyValuePair<String, String>(string2, string))) == null) {
            descriptorData = (DescriptorData)this._builtInProps.get(PropertyDescriptorDirectoryImpl.makeBuiltInPropKey(string));
        }
        if (descriptorData != null && (propertyDescriptor = (PropertyDescriptor)descriptorData.getDescriptor()).isComputed()) {
            return propertyDescriptor;
        }
        return null;
    }

    @Override
    public List<PropertyDescriptor> getPropertyDescriptors(String string) {
        if (string == null) {
            List<PropertyDescriptor> list = DescriptorData.extractDescriptors(this._predefinedProps.values());
            return list;
        }
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        for (KeyValuePair keyValuePair : this._predefinedProps.keySet()) {
            String string2 = (String)keyValuePair.getKey();
            if (!string.equals(string2)) continue;
            DescriptorData descriptorData = (DescriptorData)this._predefinedProps.get(keyValuePair);
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptorData.getDescriptor();
            arrayList.add(propertyDescriptor);
        }
        return arrayList;
    }

    @Override
    public List<PropertyDescriptor> getTextualPropertyDescriptors(String string) {
        TypeRef typeRef = this._typeRefDirectory.getTypeRef(string);
        List<DescriptorData<PropertyDescriptor>> list = (List<DescriptorData<PropertyDescriptor>>)this._textualPropsByType.get(typeRef);
        if (list == null) {
            list = this.harvestPropertyDescriptorsFor(typeRef, TypeRefUtils.STRING_TYPEREF, (Pair<String, Boolean>)new Pair((Object)PropertyDescriptorOption.TEXT_SEARCH.toString(), (Object)true));
            this._textualPropsByType.put(typeRef, list);
        }
        List<PropertyDescriptor> list2 = DescriptorData.extractDescriptors(list);
        return list2;
    }

    @Override
    public void setQueryExpression(PropertyDescriptor propertyDescriptor, String string) {
        KeyValuePair<String, String> keyValuePair = new KeyValuePair<String, String>(propertyDescriptor.getProvider(), propertyDescriptor.getName());
        List<QueryExprInfo> list = MetadataUtil.getDefaultQueryInfo(string);
        PropertyDescriptor propertyDescriptor2 = PropertyDescriptorImpl.createPropertyDescriptor(propertyDescriptor.getProvider(), propertyDescriptor.getName(), propertyDescriptor.getType(), list, propertyDescriptor.getInapplicableOperators(), propertyDescriptor.getStatus(), propertyDescriptor.getProviderResourceModelCanonicalName());
        DescriptorData<PropertyDescriptor> descriptorData = (DescriptorData<PropertyDescriptor>)this._predefinedProps.get(keyValuePair);
        if (descriptorData != null) {
            descriptorData = new DescriptorData<PropertyDescriptor>(propertyDescriptor2, descriptorData.getMessageLocalizer());
            this._predefinedProps.put(keyValuePair, descriptorData);
            return;
        }
        if (this._autogenProps.containsKey(keyValuePair)) {
            this._autogenProps.put(keyValuePair, propertyDescriptor2);
            return;
        }
    }

    @Override
    public void addAll(Collection<PropertyDescriptor> collection, MessageLocalizer messageLocalizer) {
        this.addDescriptorsTo(this._predefinedProps, collection, messageLocalizer);
    }

    @Override
    public void clearAll() {
        this._predefinedProps.clear();
        this._autogenProps.clear();
        this._textualPropsByType.clear();
    }

    void addBuiltin(List<PropertyDescriptor> list, MessageLocalizer messageLocalizer) {
        this.addDescriptorsTo(this._builtInProps, list, messageLocalizer);
    }

    private void addDescriptorsTo(ConcurrentMap<KeyValuePair<String, String>, DescriptorData<PropertyDescriptor>> concurrentMap, Collection<PropertyDescriptor> collection, MessageLocalizer messageLocalizer) {
        if (collection == null) {
            return;
        }
        for (PropertyDescriptor propertyDescriptor : collection) {
            String[] stringArray;
            if (propertyDescriptor == null) {
                _logger.warn((Object)"Null PropertyDescriptor ignored in the properties list.");
                continue;
            }
            String string = propertyDescriptor.getProvider();
            DescriptorData<PropertyDescriptor> descriptorData = new DescriptorData<PropertyDescriptor>(propertyDescriptor, messageLocalizer);
            KeyValuePair<String, String> keyValuePair = new KeyValuePair<String, String>(string, propertyDescriptor.getName());
            concurrentMap.put(keyValuePair, descriptorData);
            for (String string2 : stringArray = propertyDescriptor.getAliases()) {
                KeyValuePair<String, String> keyValuePair2 = new KeyValuePair<String, String>(string, string2);
                concurrentMap.put(keyValuePair2, descriptorData);
            }
        }
    }

    private PropertyDescriptor getPropertyDescriptorFromCache(String string, String string2, boolean bl) {
        PropertyDescriptor propertyDescriptor;
        assert (string != null);
        assert (string2 != null);
        KeyValuePair<String, String> keyValuePair = new KeyValuePair<String, String>(string, string2);
        DescriptorData descriptorData = (DescriptorData)this._predefinedProps.get(keyValuePair);
        if (descriptorData != null) {
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)descriptorData.getDescriptor();
            return propertyDescriptor2;
        }
        if (bl && (propertyDescriptor = (PropertyDescriptor)this._autogenProps.get(keyValuePair)) != null) {
            return propertyDescriptor;
        }
        propertyDescriptor = null;
        String string3 = PropertyDescriptorImpl.PropertyDescriptorUtils.stripOffMetaInfoFromPropName(string2);
        if (!string2.equals(string3)) {
            propertyDescriptor = this.getPropertyDescriptorFromCache(string, string3, bl);
        }
        return propertyDescriptor;
    }

    private PropertyDescriptor getPropertyFromSupertype(TypeRef typeRef, String string) {
        assert (typeRef != null);
        assert (string != null);
        String[] stringArray = typeRef.getSuperTypes();
        HashSet<TypeRef> hashSet = new HashSet<TypeRef>(stringArray.length);
        for (String string2 : stringArray) {
            hashSet.add(this._typeRefDirectory.getTypeRef(string2));
        }
        Object object = TypeRefUtils.removeLeafNodes(hashSet);
        while (!object.isEmpty()) {
            TypeRef typeRef2 = (TypeRef)object.poll();
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptorFromCache(typeRef2.getName(), string, false);
            if (propertyDescriptor != null) {
                return propertyDescriptor;
            }
            if (!object.isEmpty()) continue;
            object = TypeRefUtils.removeLeafNodes(hashSet);
        }
        DescriptorData descriptorData = (DescriptorData)this._builtInProps.get(PropertyDescriptorDirectoryImpl.makeBuiltInPropKey(string));
        return descriptorData == null ? null : (PropertyDescriptor)descriptorData.getDescriptor();
    }

    private PropertyDescriptor newPropertyDescriptor(String string, String string2, String string3) {
        assert (string2 != null);
        KeyValuePair<String, String> keyValuePair = new KeyValuePair<String, String>(string, string2);
        PropertyDescriptor propertyDescriptor = PropertyDescriptorImpl.createPropertyDescriptor(string, string2, null, null, null, null, string3);
        PropertyDescriptor propertyDescriptor2 = this._autogenProps.putIfAbsent(keyValuePair, propertyDescriptor);
        if (propertyDescriptor2 != null) {
            propertyDescriptor = propertyDescriptor2;
        }
        return propertyDescriptor;
    }

    private PropertyDescriptor transformPropertyDescriptorByNameMetadataIfNeeded(PropertyDescriptor propertyDescriptor, String string, String string2) {
        KeyValuePair<String, String> keyValuePair;
        PropertyDescriptor propertyDescriptor2;
        if (propertyDescriptor == null) {
            return null;
        }
        assert (string != null);
        assert (string2 != null);
        if (string2.equals(propertyDescriptor.getName()) || ArrayUtil.contains((Object)string2, (Object[])propertyDescriptor.getAliases()).booleanValue()) {
            return propertyDescriptor;
        }
        PropertyDescriptor propertyDescriptor3 = PropertyDescriptorImpl.PropertyDescriptorUtils.transformPropertyDescriptorByNameMetadata(propertyDescriptor, string, string2);
        if (propertyDescriptor3 != propertyDescriptor && (propertyDescriptor2 = this._autogenProps.putIfAbsent(keyValuePair = new KeyValuePair<String, String>(propertyDescriptor3.getProvider(), string2), propertyDescriptor3)) != null) {
            propertyDescriptor3 = propertyDescriptor2;
        }
        return propertyDescriptor3;
    }

    private List<DescriptorData<PropertyDescriptor>> harvestPropertyDescriptorsFor(TypeRef typeRef, TypeRef typeRef2, Pair<String, Boolean> pair) {
        assert (typeRef != null);
        assert (typeRef2 != null);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<DescriptorData<PropertyDescriptor>> arrayList = new ArrayList<DescriptorData<PropertyDescriptor>>();
        for (DescriptorData descriptorData : this._predefinedProps.values()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptorData.getDescriptor();
            TypeRef typeRef3 = this._typeRefDirectory.getTypeRef(propertyDescriptor.getProvider());
            TypeRef typeRef4 = this._typeRefDirectory.getTypeRef(propertyDescriptor.getType());
            String string = (String)pair.first;
            Boolean bl = (Boolean)pair.second;
            String string2 = propertyDescriptor.getTags().get(string);
            if (!typeRef2.isAssignableFrom(typeRef4) || !typeRef3.isAssignableFrom(typeRef) || !bl.toString().equals(string2) || !hashSet.add(propertyDescriptor.getName())) continue;
            arrayList.add(descriptorData);
        }
        return arrayList;
    }

    private static KeyValuePair<String, String> makeBuiltInPropKey(String string) {
        return new KeyValuePair<String, String>(TypeRefUtils.ROOT_TYPEREF.getName(), string);
    }

    private static class PropertyDescriptorWrapper
    implements PropertyDescriptor {
        private final PropertyDescriptor _originalDescriptor;
        private final String _providerResourceModelCanonicalName;

        public PropertyDescriptorWrapper(PropertyDescriptor propertyDescriptor, String string) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{propertyDescriptor});
            this._originalDescriptor = propertyDescriptor;
            this._providerResourceModelCanonicalName = string;
        }

        @Override
        public List<QueryExprInfo> getQueryExpressions() {
            return this._originalDescriptor.getQueryExpressions();
        }

        @Override
        public Map<String, String> getTags() {
            return this._originalDescriptor.getTags();
        }

        @Override
        public String getStatus() {
            return this._originalDescriptor.getStatus();
        }

        @Override
        public String getName() {
            return this._originalDescriptor.getName();
        }

        @Override
        public String getSimpleName() {
            return this._originalDescriptor.getSimpleName();
        }

        @Override
        public String getProvider() {
            return this._originalDescriptor.getProvider();
        }

        @Override
        public String getProviderResourceModel() {
            return this._originalDescriptor.getProviderResourceModel();
        }

        @Override
        public String getProviderResourceModelCanonicalName() {
            return this._providerResourceModelCanonicalName;
        }

        @Override
        public String getType() {
            return this._originalDescriptor.getType();
        }

        @Override
        public boolean isMultiCardinality() {
            return this._originalDescriptor.isMultiCardinality();
        }

        @Override
        public String[] getAliases() {
            return this._originalDescriptor.getAliases();
        }

        @Override
        public String getTitle() {
            return this._originalDescriptor.getTitle();
        }

        @Override
        public Units getUnit() {
            return this._originalDescriptor.getUnit();
        }

        @Override
        public Units getDisplayForm() {
            return this._originalDescriptor.getDisplayForm();
        }

        @Override
        public boolean isComputed() {
            return this._originalDescriptor.isComputed();
        }

        @Override
        public boolean isUnsupportedPropertySortable() {
            return this._originalDescriptor.isUnsupportedPropertySortable();
        }

        @Override
        public Set<String> getDependencyResourceModels() {
            return this._originalDescriptor.getDependencyResourceModels();
        }

        @Override
        public List<Restriction> getValueSpace() {
            return this._originalDescriptor.getValueSpace();
        }

        @Override
        public String getInapplicableOperators() {
            return this._originalDescriptor.getInapplicableOperators();
        }

        @Override
        @Deprecated
        public String getPath() {
            return this._originalDescriptor.getPath();
        }
    }
}

