/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.metadata.CodeFlavor;
import com.vmware.vise.search.metadata.DescriptorDirectoryStoreAccess;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.PropertyDescriptorDirectory;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptorDirectory;
import com.vmware.vise.search.metadata.RelationDescriptorImpl;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.search.metadata.TypeDescriptorDirectory;
import com.vmware.vise.search.xquery.ComparisonExpression;
import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.ParenthesizedExpression;
import com.vmware.vise.search.xquery.PathExpression;
import com.vmware.vise.search.xquery.PredicatedExpression;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class RelationDescriptorDirectoryBase
implements RelationDescriptorDirectory,
DescriptorDirectoryStoreAccess<RelationDescriptor> {
    private static final String EXPR_EVERYTHING = "//*";
    private static final Expression EXPR_XLINK_HREF = new LiteralExpression("@xlink:href");
    private static final Log _logger = LogFactory.getLog(RelationDescriptorDirectoryBase.class);
    private final ConcurrentMap<Object, RelationDescriptor> _predefinedRelations = new ConcurrentHashMap<Object, RelationDescriptor>();
    private final ConcurrentMap<Object, RelationDescriptor> _autogenRelations = new ConcurrentHashMap<Object, RelationDescriptor>();
    private final TypeDescriptorDirectory _typeDirectory;
    private final PropertyDescriptorDirectory _propertyDirectory;

    RelationDescriptorDirectoryBase(TypeDescriptorDirectory typeDescriptorDirectory, PropertyDescriptorDirectory propertyDescriptorDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeDescriptorDirectory, propertyDescriptorDirectory});
        this._typeDirectory = typeDescriptorDirectory;
        this._propertyDirectory = propertyDescriptorDirectory;
    }

    protected final RelationDescriptor createRelationshipDescriptor(CodeFlavor codeFlavor, PropertyDescriptor propertyDescriptor) {
        String string = this.getTypeExpr(propertyDescriptor.getType());
        String string2 = this.getDefaultRelationalExpression(codeFlavor, propertyDescriptor, string);
        String string3 = propertyDescriptor.getProvider() + "." + propertyDescriptor.getName();
        String string4 = string3 + "-inverse";
        RelationDescriptorImpl relationDescriptorImpl = new RelationDescriptorImpl(string3, string4, propertyDescriptor.getName(), string2);
        PropertyDescriptor propertyDescriptor2 = this.getInversePropertyDescriptor(propertyDescriptor);
        String string5 = this.getTypeExpr(propertyDescriptor.getProvider());
        String string6 = this.getDefaultInverseRelationalExpression(codeFlavor, propertyDescriptor, string5);
        RelationDescriptorImpl relationDescriptorImpl2 = new RelationDescriptorImpl(string4, string3, propertyDescriptor2.getName(), string6);
        this._autogenRelations.putIfAbsent(relationDescriptorImpl2.getId(), relationDescriptorImpl2);
        this._autogenRelations.putIfAbsent(propertyDescriptor2, relationDescriptorImpl2);
        this._autogenRelations.putIfAbsent(relationDescriptorImpl.getId(), relationDescriptorImpl);
        this._autogenRelations.putIfAbsent(propertyDescriptor, relationDescriptorImpl);
        this._propertyDirectory.setQueryExpression(propertyDescriptor2, string6);
        return relationDescriptorImpl;
    }

    @Override
    public void addAll(Collection<RelationDescriptor> collection, MessageLocalizer messageLocalizer) {
        if (collection == null) {
            return;
        }
        for (RelationDescriptor relationDescriptor : collection) {
            if (relationDescriptor == null) {
                _logger.warn((Object)"Null RelationDescriptor ignored in the properties list.");
                continue;
            }
            String string = relationDescriptor.getSourceType();
            String string2 = relationDescriptor.getPropertyName();
            PropertyDescriptor propertyDescriptor = this._propertyDirectory.getPropertyDescriptor(string2, string);
            this._predefinedRelations.put(propertyDescriptor, relationDescriptor);
            this._predefinedRelations.put(relationDescriptor.getId(), relationDescriptor);
        }
    }

    @Override
    public void clearAll() {
        this._predefinedRelations.clear();
        this._autogenRelations.clear();
    }

    protected final RelationDescriptor getDescriptorByKey(Object object, boolean bl) {
        RelationDescriptor relationDescriptor = (RelationDescriptor)this._predefinedRelations.get(object);
        if (relationDescriptor == null && bl) {
            relationDescriptor = (RelationDescriptor)this._autogenRelations.get(object);
        }
        return relationDescriptor;
    }

    private PropertyDescriptor getInversePropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        assert (propertyDescriptor != null);
        String string = propertyDescriptor.getName() + "-inverse";
        String string2 = propertyDescriptor.getType();
        PropertyDescriptor propertyDescriptor2 = this._propertyDirectory.getPropertyDescriptor(string, string2);
        return propertyDescriptor2;
    }

    private String getTypeExpr(String string) {
        String string2 = null;
        if (string != null) {
            TypeDescriptor typeDescriptor = this._typeDirectory.getTypeDescriptor(string);
            string2 = MetadataUtil.getQueryExpression(typeDescriptor);
        }
        if (string2 == null) {
            string2 = EXPR_EVERYTHING;
        }
        return string2;
    }

    private String getDefaultRelationalExpression(CodeFlavor codeFlavor, PropertyDescriptor propertyDescriptor, String string) {
        ComparisonExpression comparisonExpression;
        Expression expression;
        Expression expression2;
        PathExpression pathExpression;
        String string2 = MetadataUtil.getQueryExpression(propertyDescriptor);
        LiteralExpression literalExpression = new LiteralExpression(string);
        VarRefExpression varRefExpression = new VarRefExpression("target");
        LiteralExpression literalExpression2 = new LiteralExpression(string2);
        if ("@qs:resource".equals(string2)) {
            pathExpression = new PathExpression(varRefExpression, literalExpression2);
        } else {
            expression2 = EXPR_XLINK_HREF;
            pathExpression = new PathExpression(varRefExpression, literalExpression2, expression2);
        }
        expression2 = new LiteralExpression("@qs:id");
        ComparisonExpression comparisonExpression2 = new ComparisonExpression(expression2, ComparisonExpression.Operator.EQUALS, pathExpression);
        if (codeFlavor == CodeFlavor.VMODL2_SUPPORT) {
            expression = new LiteralExpression("@qs:resource");
            comparisonExpression = new ComparisonExpression(expression, ComparisonExpression.Operator.EQUALS, pathExpression);
        } else {
            comparisonExpression = comparisonExpression2;
        }
        expression = new PredicatedExpression(literalExpression, comparisonExpression);
        return expression.evaluate();
    }

    private String getDefaultInverseRelationalExpression(CodeFlavor codeFlavor, PropertyDescriptor propertyDescriptor, String string) {
        Expression expression;
        Expression expression2;
        LiteralExpression literalExpression;
        Expression expression3;
        Expression expression4;
        String string2 = MetadataUtil.getQueryExpression(propertyDescriptor);
        LiteralExpression literalExpression2 = new LiteralExpression(string2);
        if ("@qs:resource".equals(string2)) {
            expression4 = literalExpression2;
        } else {
            expression3 = EXPR_XLINK_HREF;
            expression4 = new PathExpression(literalExpression2, expression3);
        }
        expression3 = new VarRefExpression("target");
        LiteralExpression literalExpression3 = new LiteralExpression("@qs:id");
        PathExpression pathExpression = new PathExpression(expression3, literalExpression3);
        ComparisonExpression comparisonExpression = new ComparisonExpression(expression4, ComparisonExpression.Operator.EQUALS, pathExpression);
        if (codeFlavor == CodeFlavor.VMODL2_SUPPORT) {
            literalExpression = new LiteralExpression("@qs:resource");
            expression2 = new PathExpression(expression3, literalExpression);
            ComparisonExpression comparisonExpression2 = new ComparisonExpression(expression4, ComparisonExpression.Operator.EQUALS, expression2);
            String string3 = propertyDescriptor.getProviderResourceModel();
            expression = string3 != null ? XQueryUtils.addModelMatchingExpression(string3, new ParenthesizedExpression(comparisonExpression2)) : comparisonExpression2;
        } else {
            expression = comparisonExpression;
        }
        literalExpression = new LiteralExpression(string);
        expression2 = new PredicatedExpression(literalExpression, expression);
        return expression2.evaluate();
    }
}

