/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.transport.impl;

import com.vmware.vim.query.client.Client;
import com.vmware.vim.query.client.exception.UnauthenticatedException;
import com.vmware.vise.search.impl.QueryContext;
import com.vmware.vise.search.transport.HostConnectException;
import com.vmware.vise.search.transport.QueryServiceDisposedException;
import com.vmware.vise.search.transport.QueryServiceException;
import com.vmware.vise.search.transport.impl.LinkedQueryServiceGroup;
import com.vmware.vise.search.transport.impl.QueryClientUtil;
import com.vmware.vise.search.transport.impl.QueryRequest;
import com.vmware.vise.search.transport.impl.QueryServiceClientPool;
import com.vmware.vise.search.transport.impl.QueryServiceUtil;
import com.vmware.vise.search.transport.impl.SslCertificateChangedException;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.BlockingCounter;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QueryServiceCaller {
    private static final Logger _logger = LoggerFactory.getLogger(QueryServiceCaller.class);
    private final LinkedQueryServiceGroup _vcServiceGroup;
    private final BlockingCounter _openRequests;
    private final QueryRequest _request;
    private final QueryServiceClientPool _queryServiceClientPool;
    private final Set<String> _guidsOfAllQueryServicesInTheFederation;
    private final Set<String> _queriedServices = new HashSet<String>();
    private Exception _lastError = null;
    private VcService _currentService;
    private boolean _usingPredeterminedService = false;
    private int retries = 0;

    QueryServiceCaller(LinkedQueryServiceGroup linkedQueryServiceGroup, BlockingCounter blockingCounter, QueryServiceClientPool queryServiceClientPool, Set<String> set, QueryRequest queryRequest, QueryContext queryContext) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{linkedQueryServiceGroup, blockingCounter, queryServiceClientPool, set, queryRequest, queryContext});
        this._vcServiceGroup = linkedQueryServiceGroup;
        this._openRequests = blockingCounter;
        this._queryServiceClientPool = queryServiceClientPool;
        this._guidsOfAllQueryServicesInTheFederation = set;
        this._request = queryRequest;
        if (queryContext != null) {
            this._currentService = queryContext.getTargetSpecificVcService();
            if (this._currentService != null) {
                this._usingPredeterminedService = true;
                queryRequest.options.federated = false;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Will send a non-federated query to VC service " + this._currentService.getServiceUrl());
                }
            }
        }
        if (this._currentService == null) {
            this._currentService = this._vcServiceGroup.getCurrentService();
        }
        if (this._currentService == null) {
            throw new IllegalStateException("currentService could not be determined");
        }
    }

    InputStream attemptRequest() throws QueryServiceException, InterruptedException {
        try {
            this._request.label = "IS query, " + this._currentService.getServiceUrl() + "-" + this.retries;
            InputStream inputStream = this.processRequest();
            return inputStream;
        }
        catch (HostConnectException hostConnectException) {
            this._lastError = hostConnectException;
            VcService vcService = this._currentService;
            this._currentService = this.getAnotherService(this._currentService, this._usingPredeterminedService);
            String string = null;
            try {
                ServiceEndpointEx serviceEndpointEx = QueryServiceUtil.getInventoryServiceEndpoint(vcService);
                if (serviceEndpointEx != null) {
                    string = serviceEndpointEx.getUrl();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                string = vcService.getServiceUrl();
            }
            _logger.warn("Failed to connect to service " + string + (this._request.retries <= 0 ? "" : ". Will retry using service " + this._currentService.getServiceUrl()) + ". The failed request was " + (this._request.options.federated ? "" : "non-") + "federated.", (Throwable)hostConnectException);
            this._usingPredeterminedService = false;
            this._request.options.federated = true;
        }
        catch (Exception exception) {
            if (exception instanceof ExecutionException && exception.getCause() instanceof QueryServiceException) {
                throw (QueryServiceException)exception.getCause();
            }
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            throw new QueryServiceException(this._request.xquery, this._vcServiceGroup.getStartupServiceUrl(), "Query failed.", exception);
        }
        return null;
    }

    Exception getLastError() {
        return this._lastError;
    }

    Set<String> getQueriedServices() {
        return this._queriedServices;
    }

    private InputStream processRequest() throws Exception {
        InputStream inputStream = this.dispatchRequest(this._request, this._currentService);
        if (this._request.options.federated) {
            this._queriedServices.addAll(this._guidsOfAllQueryServicesInTheFederation);
        } else {
            ServiceEndpointEx serviceEndpointEx = QueryServiceUtil.getInventoryServiceEndpoint(this._currentService);
            this._queriedServices.add(serviceEndpointEx.instanceUuid);
        }
        return inputStream;
    }

    private VcService getAnotherService(VcService vcService, boolean bl) {
        assert (vcService != null);
        VcService vcService2 = null;
        if (!bl) {
            vcService2 = this._vcServiceGroup.nextService(vcService);
            return vcService2;
        }
        ServiceEndpointEx serviceEndpointEx = QueryServiceUtil.getInventoryServiceEndpoint(vcService);
        _logger.warn("Failed to connect directly to the Inventory Service for VcService " + vcService.getServiceUrl() + (serviceEndpointEx != null ? "  (IS URL: " + serviceEndpointEx.getUrl() + ")" : "") + ". Will try to connect through the federation.");
        VcService vcService3 = this._vcServiceGroup.getCurrentService();
        vcService2 = !vcService3.equals(vcService) ? vcService3 : this._vcServiceGroup.nextService(vcService);
        return vcService2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream dispatchRequest(QueryRequest queryRequest, VcService vcService) throws Exception {
        assert (queryRequest != null);
        assert (vcService != null);
        boolean bl = this._openRequests.increment();
        if (!bl) {
            throw new QueryServiceDisposedException();
        }
        try {
            InputStream inputStream;
            queryRequest.vcService = vcService;
            InputStream inputStream2 = inputStream = this.executeQuery(queryRequest);
            return inputStream2;
        }
        finally {
            this._openRequests.decrement();
        }
    }

    private InputStream executeQuery(QueryRequest queryRequest) throws Exception {
        assert (queryRequest != null);
        InputStream inputStream = null;
        Client client = this._queryServiceClientPool.getClient(queryRequest.vcService);
        try {
            if (client == null) {
                _logger.warn("The client is null");
                return null;
            }
            inputStream = QueryClientUtil.executeQuery(client, queryRequest);
        }
        catch (UnauthenticatedException unauthenticatedException) {
            String string = QueryServiceUtil.getUri(queryRequest.vcService);
            String string2 = QueryClientUtil.formatLogMessage(string, "Unauthenticated attempt for dispatching query (%s: %s). Maybe the Inventory Service session expired. Will try to relogin.", ((Object)((Object)unauthenticatedException)).getClass().getName(), unauthenticatedException.getMessage());
            String string3 = SessionUtil.getSessionInfo();
            string2 = string2 + " (" + string3 + ")";
            _logger.info(string2);
            _logger.debug("", (Throwable)unauthenticatedException);
            this._queryServiceClientPool.closeClient(queryRequest.vcService, client);
            try {
                client = this._queryServiceClientPool.getClient(queryRequest.vcService);
                _logger.info("Relogin successful. Proceeding with query execution.");
            }
            catch (Exception exception) {
                _logger.error("Relogin failed.", (Throwable)exception);
                throw exception;
            }
            inputStream = QueryClientUtil.executeQuery(client, queryRequest);
        }
        catch (SslCertificateChangedException sslCertificateChangedException) {
            _logger.warn("IS thumbrint has changed. Going to relogin.");
            this._queryServiceClientPool.closeClient(queryRequest.vcService, client);
            client = this._queryServiceClientPool.getClient(queryRequest.vcService);
            _logger.info("Relogin successful. Proceeding with query execution.");
            inputStream = QueryClientUtil.executeQuery(client, queryRequest);
        }
        assert (inputStream != null);
        return inputStream;
    }
}

