/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery;

import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.ParenthesizedExpression;
import com.vmware.vise.search.xquery.PrimaryExpression;

public class PredicatedExpression
implements Expression {
    private static final String DELIMITER = Character.toString(',');
    private final PrimaryExpression _primaryExpr;
    private final Expression _predicateExpr;

    public PredicatedExpression(PrimaryExpression primaryExpression, Expression expression) {
        this._primaryExpr = primaryExpression;
        this._predicateExpr = expression;
    }

    @Override
    public String evaluate() {
        String string = this._primaryExpr.evaluate();
        if (Strings.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("SetExp must be defined.");
        }
        String string2 = this._predicateExpr.evaluate();
        if (Strings.isNullOrEmpty(string2)) {
            return string;
        }
        if (PredicatedExpression.hasPredicate(string) || !PredicatedExpression.isDefinedTypeSequence(string)) {
            return this.createPredicatedSetExpr(string, string2);
        }
        if (!string.contains(DELIMITER)) {
            return this.createPredicatedSetExpr(string, string2);
        }
        String string3 = Strings.firstQuotedWord(string, '(', ')');
        String[] stringArray = string3.split(DELIMITER);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (String string4 : stringArray) {
            stringArray2[n++] = this.createPredicatedSetExpr(string4, string2);
        }
        String string5 = Strings.join(DELIMITER, stringArray2);
        ParenthesizedExpression parenthesizedExpression = new ParenthesizedExpression(new LiteralExpression(string5));
        return parenthesizedExpression.evaluate();
    }

    private String createPredicatedSetExpr(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append('[').append(string2).append(']');
        return stringBuilder.toString();
    }

    private static boolean hasPredicate(String string) {
        int n = string.lastIndexOf(41);
        return string.indexOf(91, n) >= 0 && string.indexOf(93, n) >= 0;
    }

    private static boolean isDefinedTypeSequence(String string) {
        String[] stringArray;
        int n = string.indexOf(40);
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf(41, n);
        if (n2 < 0) {
            return false;
        }
        for (String string2 : stringArray = string.substring(n + 1, n2).split(DELIMITER)) {
            if (string2.trim().startsWith("/")) continue;
            return false;
        }
        return true;
    }
}

