/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery;

import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.FunctionExpression;
import com.vmware.vise.search.xquery.SequenceExpression;

public class SetExpression
implements Expression {
    private final Operator _operator;
    private final Expression[] _operands;

    public SetExpression(Expression expression, Operator operator, Expression expression2) {
        this._operator = operator;
        this._operands = new Expression[2];
        this._operands[0] = expression;
        this._operands[1] = expression2;
    }

    public SetExpression(Operator operator, Expression ... expressionArray) {
        this._operator = operator;
        this._operands = expressionArray;
    }

    @Override
    public String evaluate() {
        if (this._operands.length == 1) {
            String string = this._operands[0].evaluate();
            return string;
        }
        if (this._operator == Operator.UNION) {
            SequenceExpression sequenceExpression = new SequenceExpression(this._operands);
            FunctionExpression functionExpression = new FunctionExpression("fn:distinct-nodes", sequenceExpression);
            String string = functionExpression.evaluate();
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < this._operands.length; ++i) {
            String string = this._operands[i].evaluate();
            stringBuilder.append(string);
            if (i >= this._operands.length - 1) continue;
            stringBuilder.append(')').append(' ').append(this._operator.toString()).append(' ').append('(');
        }
        stringBuilder.append(')');
        String string = stringBuilder.toString();
        return string;
    }

    public static enum Operator {
        INTERSECT{

            public String toString() {
                return "intersect";
            }
        }
        ,
        UNION{

            public String toString() {
                return "union";
            }
        }
        ,
        EXCEPT{

            public String toString() {
                return "except";
            }
        };

    }
}

