/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.search.OrderingCriteria;
import com.vmware.vise.search.OrderingPropertySpec;
import com.vmware.vise.search.PropertySpec;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.search.util.Renderer;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.search.xquery.render.RendererFactory;
import com.vmware.vise.search.xquery.render.ReturnClauseGenerator;
import com.vmware.vise.search.xquery.render.SingleModelReturnClauseGenerator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class LegacyReturnClauseGenerator
implements ReturnClauseGenerator {
    private final MetadataDirectory _metadataDirectory;
    private final RendererFactory _rendererFactory;

    public LegacyReturnClauseGenerator(MetadataDirectory metadataDirectory, RendererFactory rendererFactory) {
        this._metadataDirectory = metadataDirectory;
        this._rendererFactory = rendererFactory;
    }

    @Override
    public String generate(ResponseSpec responseSpec) {
        ResponseSpec responseSpec2 = this.toCompatResponseSpec(responseSpec);
        SingleModelReturnClauseGenerator singleModelReturnClauseGenerator = new SingleModelReturnClauseGenerator(this._metadataDirectory, this._rendererFactory, null);
        Renderer renderer = this._rendererFactory.newItemCountClauseRenderer(new VarRefExpression("targetSet"));
        return singleModelReturnClauseGenerator.generate(responseSpec2) + "\n" + renderer.render();
    }

    private ResponseSpec toCompatResponseSpec(ResponseSpec responseSpec) {
        boolean bl;
        PropertySpec[] propertySpecArray;
        boolean bl2;
        OrderingPropertySpec[] orderingPropertySpecArray;
        OrderingCriteria orderingCriteria = responseSpec.orderingCriteria;
        if (orderingCriteria != null && !ArrayUtils.isEmpty((Object[])orderingCriteria.applicableProperties)) {
            orderingPropertySpecArray = (OrderingPropertySpec[])this.extractCompatPropSpecs(orderingCriteria.applicableProperties, OrderingPropertySpec.class);
            bl2 = orderingPropertySpecArray != orderingCriteria.applicableProperties;
        } else {
            orderingPropertySpecArray = null;
            bl2 = false;
        }
        if (ArrayUtils.isEmpty((Object[])responseSpec.propertiesToRetrieve)) {
            propertySpecArray = this.extractCompatPropSpecs(responseSpec.propertiesToRetrieve, PropertySpec.class);
            bl = propertySpecArray != responseSpec.propertiesToRetrieve;
        } else {
            propertySpecArray = responseSpec.propertiesToRetrieve;
            bl = false;
        }
        if (bl2 || bl) {
            ResponseSpec responseSpec2 = responseSpec.getDeepCopy();
            responseSpec2.propertiesToRetrieve = propertySpecArray;
            if (responseSpec2.orderingCriteria != null) {
                responseSpec2.orderingCriteria.applicableProperties = orderingPropertySpecArray;
            }
            return responseSpec2;
        }
        return responseSpec;
    }

    private <T extends PropertySpec> T[] extractCompatPropSpecs(T[] TArray, Class<T> clazz) {
        if (ArrayUtils.isEmpty((Object[])TArray)) {
            return TArray;
        }
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (T t : TArray) {
            Object object;
            Object[] objectArray;
            if (ArrayUtils.isEmpty((Object[])((PropertySpec)t).properties)) {
                arrayList.add(t);
                continue;
            }
            String string = ((PropertySpec)t).providerType;
            if (!StringUtils.isEmpty((String)((PropertySpec)t).relationship)) {
                objectArray = MetadataUtil.getRelationshipHops(this._metadataDirectory, ((PropertySpec)t).providerType, ((PropertySpec)t).relationship);
                assert (objectArray != null);
                if (this.hasVmodl2Relationships((RelationDescriptor[])objectArray)) continue;
                object = objectArray[objectArray.length - 1];
                string = MetadataUtil.getTargetType(object, this._metadataDirectory);
            }
            if ((objectArray = this.extractCompatProperties(((PropertySpec)t).properties, string)) == ((PropertySpec)t).properties) {
                object = ((PropertySpec)t).getDeepCopy();
                ((PropertySpec)object).properties = objectArray;
            } else {
                object = t;
            }
            arrayList.add(object);
        }
        if (arrayList.size() == TArray.length) {
            return TArray;
        }
        return arrayList.toArray((PropertySpec[])Array.newInstance(clazz, arrayList.size()));
    }

    private String[] extractCompatProperties(String[] stringArray, String string) {
        assert (stringArray != null);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            PropertyDescriptor propertyDescriptor;
            String string3 = ModelUtils.getResourceModel(string2);
            if (string3 != null || ModelUtils.hasVmodl2Name((propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string2, string)).getDependencyResourceModels())) continue;
            arrayList.add(string2);
        }
        if (arrayList.size() == stringArray.length) {
            return stringArray;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean hasVmodl2Relationships(RelationDescriptor[] relationDescriptorArray) {
        for (RelationDescriptor relationDescriptor : relationDescriptorArray) {
            if (!this.isVmodl2Relation(relationDescriptor)) continue;
            return true;
        }
        return false;
    }

    private boolean isVmodl2Relation(RelationDescriptor relationDescriptor) {
        return ModelUtils.getResourceModel(relationDescriptor.getPropertyName()) != null;
    }
}

