/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.xhive.fts;

import com.vmware.vise.search.util.Token;
import com.vmware.vise.search.util.TokenType;
import com.vmware.vise.search.util.TranslationRule;
import com.vmware.vise.search.util.Translator;
import com.vmware.vise.search.xquery.xhive.fts.DefaultTranslationRuleImpl;
import com.vmware.vise.search.xquery.xhive.fts.ExactMatchXhiveFtsTranslationRuleImpl;
import com.vmware.vise.search.xquery.xhive.fts.WildCardXhiveFtsTranslationRuleImpl;
import com.vmware.vise.search.xquery.xhive.fts.XhiveFtsTextLexicalAnalyzerImpl;
import java.util.HashMap;
import java.util.Map;

final class XhiveFtsTranslatorImpl
implements Translator {
    private static final String XHIVE_FTS_ESCAPE_SEARCH_PATTERN = "[+\\-!():^\\[\\]{}~?]";
    private static final String XHIVE_FTS_ESCAPE_REPLACEMENT_PATTERN = "\\\\$0";
    private static final Map<TokenType, TranslationRule> _translationRules = new HashMap<TokenType, TranslationRule>();

    XhiveFtsTranslatorImpl() {
    }

    @Override
    public String translate(String string) {
        String string2 = XhiveFtsTranslatorImpl.xhiveFtsEscapeSpecialChars(string);
        XhiveFtsTextLexicalAnalyzerImpl xhiveFtsTextLexicalAnalyzerImpl = new XhiveFtsTextLexicalAnalyzerImpl();
        Token[] tokenArray = xhiveFtsTextLexicalAnalyzerImpl.analyze(string2);
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : tokenArray) {
            TranslationRule translationRule = this.findTranslationRule(token);
            String string3 = translationRule.apply(token.getText());
            stringBuilder.append(String.format(" %1$s", string3));
        }
        String string4 = stringBuilder.toString().trim();
        return string4;
    }

    private TranslationRule findTranslationRule(Token token) {
        TranslationRule translationRule = _translationRules.get((Object)token.getTokenType());
        return translationRule == null ? new DefaultTranslationRuleImpl() : translationRule;
    }

    private static String xhiveFtsEscapeSpecialChars(String string) {
        string = string.replace("%5c*", "\\*");
        return string.replaceAll(XHIVE_FTS_ESCAPE_SEARCH_PATTERN, XHIVE_FTS_ESCAPE_REPLACEMENT_PATTERN);
    }

    static {
        _translationRules.put(TokenType.Quoted, new ExactMatchXhiveFtsTranslationRuleImpl());
        _translationRules.put(TokenType.Regular, new WildCardXhiveFtsTranslationRuleImpl());
    }
}

