/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.perfmon;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.util.Arrays;
import java.util.Comparator;

public class PerfmonAggregator {
    public static StopWatch startStopWatch(String name) {
        return new StopWatch(name);
    }

    public static void sample(String name, String units, int value) {
        if (units.equals("ms.")) {
            throw new IllegalArgumentException("Units 'ms.' are reserved for use by the system.  To aggregate time intervals, use method startStopWatch");
        }
        MonitorFactory.add((String)name, (String)units, (double)value);
    }

    public static String getHtmlReport() {
        Monitor[] mons = MonitorFactory.getRootMonitor().getMonitors();
        if (mons == null) {
            return "";
        }
        mons = (Monitor[])mons.clone();
        Arrays.sort(mons, new Comparator<Monitor>(){

            @Override
            public int compare(Monitor o1, Monitor o2) {
                String s1 = o1.getLabel();
                String s2 = o2.getLabel();
                return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
            }
        });
        String[] col_names = new String[]{"Label", "Units", "Samples", "Total", "Min", "Max", "Average"};
        StringBuilder html = new StringBuilder();
        html.append("\n<table border='1' rules='all'>");
        html.append("\n");
        for (String string : col_names) {
            html.append("<th>").append(string).append("</th>");
        }
        html.append("\n");
        for (String string : mons) {
            html.append("<tr>");
            html.append("<td>").append(string.getLabel()).append("</td>");
            html.append("<td>").append(string.getUnits()).append("</td>");
            html.append("<td>").append((long)string.getHits()).append("</td>");
            html.append("<td>").append((long)string.getTotal()).append("</td>");
            html.append("<td>").append((long)string.getMin()).append("</td>");
            html.append("<td>").append((long)string.getMax()).append("</td>");
            html.append("<td>").append((long)string.getAvg()).append("</td>");
            html.append("</tr>").append("\n");
        }
        html.append("</table>");
        return html.toString();
    }

    public static class StopWatch {
        private final Monitor _mon;

        private StopWatch(String name) {
            this._mon = MonitorFactory.start((String)name);
        }

        public void stop() {
            this._mon.stop();
        }
    }
}

