/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class JaxbUtil {
    private static final ConcurrentHashMap<Class, JAXBContext> _jaxbCtxMap = new ConcurrentHashMap();

    public static <T> void marshal(Writer w, T obj, String schemaFile) throws JAXBException, SAXException, IOException {
        Marshaller marshaller = JaxbUtil.createMarshaller(obj.getClass(), schemaFile);
        marshaller.marshal(obj, w);
        w.flush();
    }

    public static <T> T unmarshal(InputStream in, Class<T> klass, String schemaFile) throws JAXBException, SAXException {
        Unmarshaller unmarshaller = JaxbUtil.createUnmarshaller(klass, schemaFile);
        return (T)unmarshaller.unmarshal(in);
    }

    public static <T> T unmarshalWithSchemaStream(InputStream in, Class<T> klass, InputStream schemaStream) throws JAXBException, SAXException {
        Unmarshaller unmarshaller = JaxbUtil.createUnmarshallerWithSchemaStream(klass, schemaStream);
        return (T)unmarshaller.unmarshal(in);
    }

    public static Marshaller createMarshaller(Class classToBeBound, String schemaFile) throws JAXBException, SAXException {
        JAXBContext jc = JaxbUtil.getJaxbContext(classToBeBound);
        Marshaller marshaller = jc.createMarshaller();
        if (schemaFile != null) {
            marshaller.setSchema(JaxbUtil.getXmlSchema(schemaFile));
        }
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller(Class classToBeBound, String schemaFile) throws JAXBException, SAXException {
        return JaxbUtil.createUnmarshallerWithSchemaStream(classToBeBound, schemaFile == null ? null : JaxbUtil.class.getClassLoader().getResourceAsStream(schemaFile));
    }

    public static Unmarshaller createUnmarshallerWithSchemaStream(Class classToBeBound, InputStream schemaStream) throws JAXBException, SAXException {
        JAXBContext jc = JaxbUtil.getJaxbContext(classToBeBound);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        if (schemaStream != null) {
            unmarshaller.setSchema(JaxbUtil.getXmlSchema(schemaStream));
        }
        return unmarshaller;
    }

    private static JAXBContext getJaxbContext(Class classToBeBound) throws JAXBException {
        JAXBContext jc = _jaxbCtxMap.get(classToBeBound);
        if (jc == null) {
            jc = JAXBContext.newInstance((Class[])new Class[]{classToBeBound});
            _jaxbCtxMap.putIfAbsent(classToBeBound, jc);
        }
        return jc;
    }

    private static Schema getXmlSchema(String schemaFile) throws SAXException {
        return JaxbUtil.getXmlSchema(JaxbUtil.class.getClassLoader().getResourceAsStream(schemaFile));
    }

    private static Schema getXmlSchema(InputStream schemaStream) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource source = new StreamSource(schemaStream);
        return schemaFactory.newSchema(source);
    }
}

