/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.vapi;

import com.vmware.cis.services.common.sso.StsCertManager;
import com.vmware.vapi.cis.authn.json.JsonSignatureVerificationProcessor;
import com.vmware.vapi.dsig.json.StsTrustChain;
import com.vmware.vapi.protocol.RequestProcessor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

class SamlSignatureVerificationProcessor
implements RequestProcessor {
    private final StsCertManager _stsCertManager;
    private final JsonSignatureVerificationProcessor _json;

    public SamlSignatureVerificationProcessor(StsCertManager stsCertManager) {
        this._stsCertManager = stsCertManager;
        this._json = new JsonSignatureVerificationProcessor(new StsTrustChain(){

            public X509Certificate[] getStsTrustChain() {
                List<X509Certificate> tmp = SamlSignatureVerificationProcessor.this._stsCertManager.getStsCertificates();
                return tmp.toArray(new X509Certificate[tmp.size()]);
            }
        });
    }

    public byte[] process(byte[] request, Map<String, Object> metadata, RequestProcessor.Request vapiRequest) {
        byte[] result = this._json.process(request, metadata, vapiRequest);
        Map authnData = (Map)metadata.get("security_context");
        if (authnData != null && authnData.get("saml_error") != null) {
            this._stsCertManager.refetchStsCertificates();
            result = this._json.process(request, metadata, vapiRequest);
        }
        return result;
    }
}

