/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.api;

import com.vmware.cis.data.api.ResultSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;

public final class ResourceItem {
    private final List<Object> _propertyValues;
    private final ResultSet.PropertyIndex _propertyIndex;

    ResourceItem(List<Object> propertyValues, ResultSet.PropertyIndex propertyIndex) {
        assert (propertyValues != null);
        assert (!propertyValues.isEmpty());
        assert (propertyIndex != null);
        this._propertyValues = Collections.unmodifiableList(propertyValues);
        this._propertyIndex = propertyIndex;
    }

    public List<Object> getPropertyValues() {
        return this._propertyValues;
    }

    public <T> T get(int propertyIndex) {
        return this.getValueAt(propertyIndex);
    }

    public <T> T get(String property) {
        Validate.notEmpty((String)property, (String)"Property name must not be null or empty");
        int propertyIndex = this._propertyIndex.getIndexOfProperty(property);
        if (propertyIndex < 0) {
            throw new IllegalArgumentException("ResultSet does not contain property: " + property);
        }
        return this.getValueAt(propertyIndex);
    }

    public <T> T getKey() {
        return this.get("@modelKey");
    }

    private <T> T getValueAt(int propertyIndex) {
        if (propertyIndex < 0 || propertyIndex >= this._propertyValues.size()) {
            throw new IllegalArgumentException("Invalid property index: " + propertyIndex);
        }
        Object value = this._propertyValues.get(propertyIndex);
        return (T)value;
    }

    public int hashCode() {
        return this._propertyValues.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceItem)) {
            return false;
        }
        ResourceItem other = (ResourceItem)obj;
        return this._propertyValues.equals(other.getPropertyValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResourceItem [" + SystemUtils.LINE_SEPARATOR);
        sb.append("         _propertyValues = ");
        if (this._propertyValues.size() == 1) {
            sb.append("[" + ResourceItem.valueToString(this._propertyValues.get(0)) + "]");
        } else {
            sb.append("[");
            Iterator<Object> iterator = this._propertyValues.iterator();
            while (iterator.hasNext()) {
                sb.append(SystemUtils.LINE_SEPARATOR + "            ");
                sb.append(ResourceItem.valueToString(iterator.next()));
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append(SystemUtils.LINE_SEPARATOR + "         ]");
        }
        sb.append(SystemUtils.LINE_SEPARATOR + "      ]");
        return sb.toString();
    }

    private static String valueToString(Object propertyValue) {
        if (propertyValue instanceof Object[]) {
            return Arrays.toString((Object[])propertyValue);
        }
        return String.valueOf(propertyValue);
    }
}

