/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.api.binding;

import com.vmware.cis.data.internal.api.binding.QueryBindingProvider;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.Validate;

public final class QueryBindingCommand<T> {
    private final QueryBindingProvider _provider;

    QueryBindingCommand(QueryBindingProvider provider) {
        assert (provider != null);
        this._provider = provider;
    }

    public T fetch(Object key) {
        Validate.notNull((Object)key);
        Collection<?> results = this._provider.fetch(Collections.singleton(key));
        if (results.isEmpty()) {
            return null;
        }
        Object result = results.iterator().next();
        return (T)result;
    }

    public Collection<T> fetch(Collection<?> keys) {
        Validate.noNullElements(keys);
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<?> results = this._provider.fetch(keys);
        return Collections.unmodifiableCollection(results);
    }
}

