/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.api.binding;

import com.vmware.cis.data.internal.util.ReflectionUtil;
import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.Relationship;
import java.lang.reflect.Field;

final class QueryBindingRelationshipValidator {
    QueryBindingRelationshipValidator() {
    }

    public static void validate(Class<?> bindingType) {
        QueryBindingRelationshipValidator.validate(bindingType, bindingType, 3);
    }

    private static void validate(Class<?> rootBindingType, Class<?> bindingType, int allowedRelationshipHops) {
        for (Field field : ReflectionUtil.getAllFields(bindingType)) {
            if (!field.isAnnotationPresent(Relationship.class) && field.isAnnotationPresent(NestedQueryBinding.class)) {
                QueryBindingRelationshipValidator.validate(rootBindingType, QueryBindingRelationshipValidator.getType(field), allowedRelationshipHops);
                continue;
            }
            if (field.isAnnotationPresent(Relationship.class) && field.isAnnotationPresent(NestedQueryBinding.class)) {
                QueryBindingRelationshipValidator.validateRelationshipHops(rootBindingType, field, allowedRelationshipHops);
                QueryBindingRelationshipValidator.validate(rootBindingType, QueryBindingRelationshipValidator.getType(field), QueryBindingRelationshipValidator.calcRemainingRelationshipHops(field, allowedRelationshipHops));
                continue;
            }
            if (!field.isAnnotationPresent(Relationship.class) || !field.isAnnotationPresent(Property.class)) continue;
            QueryBindingRelationshipValidator.validateRelationshipHops(rootBindingType, field, allowedRelationshipHops);
        }
    }

    private static void validateRelationshipHops(Class<?> rootBindingType, Field field, int allowedRelationshipHops) {
        String[] relationshipHops = field.getAnnotation(Relationship.class).value();
        if (relationshipHops.length > allowedRelationshipHops) {
            String msg = String.format("Too many relationship hops in binding: %s. The allowed maximum level is %d!", rootBindingType.getSimpleName(), 3);
            throw new IllegalArgumentException(msg);
        }
    }

    private static int calcRemainingRelationshipHops(Field field, int allowedRelationshipHops) {
        String[] relationshipHops = field.getAnnotation(Relationship.class).value();
        return allowedRelationshipHops - relationshipHops.length;
    }

    private static Class<?> getType(Field field) {
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            fieldType = fieldType.getComponentType();
        }
        return fieldType;
    }
}

