/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider;

import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.cis.data.internal.provider.DataProviderConnection;
import com.vmware.cis.data.internal.provider.DataProviderConnector;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeDataProviderConnection
implements AutoCloseable {
    private static final Logger _logger = LoggerFactory.getLogger(CompositeDataProviderConnection.class);
    private final List<DataProviderConnection> _connections;
    private final List<DataProvider> _providers;

    private CompositeDataProviderConnection(List<DataProviderConnection> connections) {
        assert (connections != null);
        this._connections = connections;
        ArrayList<DataProvider> providers = new ArrayList<DataProvider>(connections.size());
        for (DataProviderConnection connection : connections) {
            providers.add(connection.getDataProvider());
        }
        this._providers = Collections.unmodifiableList(providers);
    }

    public static CompositeDataProviderConnection connect(Collection<DataProviderConnector> connectors, AuthenticationTokenSource authn) {
        Validate.notNull(connectors);
        Validate.notNull((Object)authn);
        ArrayList<DataProviderConnection> connections = new ArrayList<DataProviderConnection>(connectors.size());
        for (DataProviderConnector connector : connectors) {
            try {
                DataProviderConnection connection = connector.getConnection(authn);
                connections.add(connection);
            }
            catch (RuntimeException ex) {
                _logger.error("Could not connect to Data Provider {}", (Object)connector, (Object)ex);
            }
        }
        return new CompositeDataProviderConnection(connections);
    }

    public Collection<DataProvider> getDataProviders() {
        return this._providers;
    }

    @Override
    public void close() {
        boolean shouldThrow = false;
        for (DataProviderConnection connection : this._connections) {
            try {
                connection.close();
            }
            catch (Exception ex) {
                shouldThrow = true;
                _logger.error("Could not close connection to Data Provider {}", (Object)connection, (Object)ex);
            }
        }
        if (shouldThrow) {
            throw new RuntimeException("There was an exception while closing one or more data provider connections. Check the log for more details.");
        }
    }
}

