/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.aggregated;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelPropertyConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class AggregatedModelResultConverter {
    private final AggregatedModelPropertyConverter _propertyConverter;

    public AggregatedModelResultConverter(String aggregatedModel, String childModel, Set<String> childModelPropertiesNonQualified) {
        assert (aggregatedModel != null);
        assert (childModel != null);
        assert (childModelPropertiesNonQualified != null);
        this._propertyConverter = new AggregatedModelPropertyConverter(aggregatedModel, childModel, childModelPropertiesNonQualified);
    }

    public ResultSet fromChildResult(ResultSet childResult, List<String> aggregatedProperties) {
        assert (childResult != null);
        assert (aggregatedProperties != null);
        return this.renameAndReorder(childResult, aggregatedProperties);
    }

    private ResultSet renameAndReorder(ResultSet childResult, List<String> aggregatedProperties) {
        assert (childResult != null);
        assert (aggregatedProperties != null);
        ArrayList<List<Object>> aggregatedItems = new ArrayList<List<Object>>(childResult.getItems().size());
        for (ResourceItem childItem : childResult.getItems()) {
            List<Object> aggregatedItem = this.renameAndReorder(childItem, aggregatedProperties);
            aggregatedItems.add(aggregatedItem);
        }
        return ResultSet.Builder.properties(aggregatedProperties).items(aggregatedItems).totalCount(childResult.getTotalCount()).build();
    }

    private List<Object> renameAndReorder(ResourceItem childItem, List<String> aggregatedProperties) {
        assert (childItem != null);
        assert (aggregatedProperties != null);
        ArrayList<Object> values = new ArrayList<Object>(aggregatedProperties.size());
        for (String aggregatedProperty : aggregatedProperties) {
            String childProperty = this._propertyConverter.toChildProperty(aggregatedProperty);
            Object value = null;
            if (childProperty != null) {
                value = childItem.get(childProperty);
            }
            values.add(value);
        }
        return values;
    }
}

