/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.derived;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.model.PropertyParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class DerivedPropertyDescriptor {
    public static final String DERIVED_PROPERTY_METHOD_NAME_PREFIX = "get";
    private final String _propertyName;
    private final Method _derivedPropertyMethod;
    private final String[] _propertyForParam;
    private final Set<String> _dependencyProperties;

    public static DerivedPropertyDescriptor fromMethod(String resourceModel, Method derivedPropertyMethod) {
        Validate.notEmpty((String)resourceModel, (String)"Model name must not be empty");
        Validate.notNull((Object)derivedPropertyMethod, (String)"Derived property method must not be null");
        DerivedPropertyDescriptor.validateDerivedPropertyMethod(derivedPropertyMethod);
        String derivedProperty = DerivedPropertyDescriptor.getDerivedPropertyName(resourceModel, derivedPropertyMethod);
        String[] propertyForParam = DerivedPropertyDescriptor.getPropertiesForParams(resourceModel, derivedPropertyMethod);
        DerivedPropertyDescriptor.validatePropertiesForParams(propertyForParam, derivedPropertyMethod);
        HashSet<String> dependencyProperties = new HashSet<String>(Arrays.asList(propertyForParam));
        return new DerivedPropertyDescriptor(derivedProperty, derivedPropertyMethod, propertyForParam, dependencyProperties);
    }

    private DerivedPropertyDescriptor(String propertyName, Method derivedPropertyMethod, String[] propertyForParam, Set<String> dependencyProperties) {
        assert (propertyName != null);
        assert (!propertyName.isEmpty());
        assert (derivedPropertyMethod != null);
        assert (propertyForParam != null);
        assert (dependencyProperties != null);
        this._propertyName = propertyName;
        this._derivedPropertyMethod = derivedPropertyMethod;
        this._propertyForParam = propertyForParam;
        this._dependencyProperties = Collections.unmodifiableSet(dependencyProperties);
    }

    public String getName() {
        return this._propertyName;
    }

    public Set<String> getDependencyProperties() {
        return this._dependencyProperties;
    }

    public Object invokeDerivedPropertyMethod(ResourceItem item) {
        Validate.notNull((Object)item);
        Object[] paramValues = new Object[this._propertyForParam.length];
        for (int i = 0; i < this._propertyForParam.length; ++i) {
            String property = this._propertyForParam[i];
            Object paramValue = item.get(property);
            paramValues[i] = paramValue;
        }
        try {
            return this._derivedPropertyMethod.invoke(null, paramValues);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Error while invoking derived property method '%s'", this._derivedPropertyMethod.getName()), ex);
        }
    }

    private static void validateDerivedPropertyMethod(Method derivedPropertyMethod) {
        assert (derivedPropertyMethod != null);
        if (!Modifier.isPublic(derivedPropertyMethod.getModifiers())) {
            throw new IllegalArgumentException(String.format("Derived property method '%s' must be public.", derivedPropertyMethod.getName()));
        }
        if (!Modifier.isStatic(derivedPropertyMethod.getModifiers())) {
            throw new IllegalArgumentException(String.format("Derived property method '%s' must be static.", derivedPropertyMethod.getName()));
        }
        if (Void.TYPE.equals(derivedPropertyMethod.getReturnType())) {
            throw new IllegalArgumentException(String.format("Derived property method '%s' must not return void.", derivedPropertyMethod.getName()));
        }
    }

    private static String getDerivedPropertyName(String resourceModel, Method derivedPropertyMethod) {
        assert (resourceModel != null);
        assert (derivedPropertyMethod != null);
        String simpleProperty = DerivedPropertyDescriptor.getDerivedPropertySimpleName(derivedPropertyMethod);
        return QualifiedProperty.forModelAndSimpleProperty(resourceModel, simpleProperty).toString();
    }

    private static String getDerivedPropertySimpleName(Method derivedPropertyMethod) {
        assert (derivedPropertyMethod != null);
        String methodName = derivedPropertyMethod.getName();
        if (!methodName.startsWith(DERIVED_PROPERTY_METHOD_NAME_PREFIX)) {
            throw new IllegalArgumentException(String.format("Derived property method name must start with 'get' prefix: '%s'", methodName));
        }
        if (methodName.codePointCount(0, methodName.length()) != methodName.length()) {
            throw new IllegalArgumentException(String.format("Derived property method name must use only ASCII characters: '%s'", methodName));
        }
        String rawPropertyName = methodName.substring(DERIVED_PROPERTY_METHOD_NAME_PREFIX.length());
        if (rawPropertyName.isEmpty()) {
            throw new IllegalArgumentException(String.format("Derived property method name must contain property name after the 'get' prefix: '%s'", methodName));
        }
        return Character.toLowerCase(rawPropertyName.charAt(0)) + rawPropertyName.substring(1);
    }

    private static String[] getPropertiesForParams(String resourceModel, Method derivedPropertyMethod) {
        assert (resourceModel != null);
        assert (derivedPropertyMethod != null);
        if (derivedPropertyMethod.getParameterTypes().length == 0) {
            throw new IllegalArgumentException(String.format("Derived property method '%s' has no parameters", derivedPropertyMethod.getName()));
        }
        Class<?>[] paramTypes = derivedPropertyMethod.getParameterTypes();
        Annotation[][] paramAnnotations = derivedPropertyMethod.getParameterAnnotations();
        assert (paramTypes.length == paramAnnotations.length);
        String[] paramProperties = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramProperties[i] = DerivedPropertyDescriptor.getPropertyForParam(resourceModel, derivedPropertyMethod.getName(), paramTypes[i], paramAnnotations[i]);
        }
        return paramProperties;
    }

    private static void validatePropertiesForParams(String[] propertyForParam, Method derivedPropertyMethod) {
        assert (propertyForParam != null);
        HashSet<String> properties = new HashSet<String>(propertyForParam.length);
        for (String property : propertyForParam) {
            boolean added = properties.add(property);
            if (added) continue;
            throw new IllegalArgumentException(String.format("Derived property method '%s' has multiple parameters annotated with @PropertyParam for property '%s'", derivedPropertyMethod.getName(), property));
        }
    }

    private static String getPropertyForParam(String resourceModel, String methodName, Class<?> paramType, Annotation[] paramAnnotations) {
        assert (resourceModel != null);
        assert (methodName != null);
        assert (!methodName.isEmpty());
        assert (paramType != null);
        assert (paramAnnotations != null);
        String property = null;
        for (Annotation a : paramAnnotations) {
            String propertyCandidate = DerivedPropertyDescriptor.getPropertyForAnnotation(a, paramType, methodName);
            if (propertyCandidate == null) continue;
            if (property != null) {
                throw new IllegalArgumentException(String.format("Derived property method '%s' has multiple parameter annotations on parameter of type '%s'", methodName, paramType.getCanonicalName()));
            }
            property = propertyCandidate;
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Derived property method '%s' has no parameter annotations on parameter of type '%s'", methodName, paramType.getCanonicalName()));
        }
        return property;
    }

    private static String getPropertyForAnnotation(Annotation a, Class<?> paramType, String methodName) {
        assert (a != null);
        assert (paramType != null);
        assert (methodName != null);
        assert (!methodName.isEmpty());
        if (a instanceof PropertyParam) {
            PropertyParam propertyParam = (PropertyParam)a;
            String property = propertyParam.value();
            if (StringUtils.isEmpty((String)property)) {
                throw new IllegalArgumentException(String.format("Derived property method '%s' has @PropertyParam annotation with empty property name on parameter of type '%s'", methodName, paramType.getCanonicalName()));
            }
            if (PropertyUtil.isModelKey(property)) {
                throw new IllegalArgumentException(String.format("Derived property method '%s' has @PropertyParam annotation with property name '%s'", methodName, property));
            }
            return property;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DerivedPropertyDescriptor)) {
            return false;
        }
        DerivedPropertyDescriptor other = (DerivedPropertyDescriptor)obj;
        return this._propertyName.equals(other._propertyName) && this._derivedPropertyMethod.equals(other._derivedPropertyMethod) && Arrays.equals(this._propertyForParam, other._propertyForParam) && this._dependencyProperties.equals(other._dependencyProperties);
    }

    public int hashCode() {
        int hash = 23;
        hash = 31 * hash + this._propertyName.hashCode();
        hash = 31 * hash + this._derivedPropertyMethod.hashCode();
        hash = 31 * hash + Arrays.hashCode(this._propertyForParam);
        hash = 31 * hash + this._dependencyProperties.hashCode();
        return hash;
    }

    public String toString() {
        return "DerivedPropertyDescriptor [_propertyName=" + this._propertyName + ", _derivedPropertyMethod=" + this._derivedPropertyMethod + ", _propertyForParam=" + Arrays.toString(this._propertyForParam) + ", _dependencyProperties=" + this._dependencyProperties + "]";
    }
}

