/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyLookup;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.cis.data.provider.DataProvider;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelatedLengthProviderConnection
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(RelatedLengthProviderConnection.class);
    private static final String SUFFIX_LENGTH = "/length";
    private final DataProvider _connection;
    private final RelatedPropertyLookup _relatedPropertyLookup;

    public RelatedLengthProviderConnection(DataProvider connection, RelatedPropertyLookup relatedPropertyLookup) {
        assert (connection != null);
        assert (relatedPropertyLookup != null);
        this._connection = connection;
        this._relatedPropertyLookup = relatedPropertyLookup;
    }

    @Override
    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        List<String> selectProperties = query.getProperties();
        ArrayList<Integer> relatedLengthPositions = new ArrayList<Integer>();
        List<String> modifiedSelectProperties = this.modifySelectProperties(selectProperties, relatedLengthPositions);
        if (relatedLengthPositions.isEmpty()) {
            return this._connection.executeQuery(query);
        }
        Query modifiedQuery = QueryCopy.copyAndSelect(query, modifiedSelectProperties).build();
        ResultSet result = this._connection.executeQuery(modifiedQuery);
        List<List<Object>> modifiedItems = this.modifyResourceItems(result.getItems(), relatedLengthPositions);
        return ResultSet.Builder.properties(selectProperties).items(modifiedItems).totalCount(result.getTotalCount()).build();
    }

    private List<String> modifySelectProperties(List<String> selectProperties, List<Integer> relatedLengthPositions) {
        ArrayList<String> convertedProperties = new ArrayList<String>(selectProperties.size());
        for (int index = 0; index < selectProperties.size(); ++index) {
            String selectedProperty = selectProperties.get(index);
            if (!selectedProperty.endsWith(SUFFIX_LENGTH)) {
                convertedProperties.add(selectedProperty);
                continue;
            }
            String plainProperty = StringUtils.removeEnd((String)selectedProperty, (String)SUFFIX_LENGTH);
            RelatedPropertyDescriptor descriptor = this._relatedPropertyLookup.getRelatedPropertyDescriptor(plainProperty);
            if (descriptor == null) {
                convertedProperties.add(selectedProperty);
                continue;
            }
            if (!descriptor.getType().isArray()) {
                throw new IllegalArgumentException("Cannot request length over related property which is defined as non-array:" + selectedProperty);
            }
            convertedProperties.add(plainProperty);
            relatedLengthPositions.add(index);
            _logger.warn("Counting of the values for property '{}' will be taken on client side.", (Object)selectedProperty);
        }
        return convertedProperties;
    }

    private List<List<Object>> modifyResourceItems(List<ResourceItem> items, List<Integer> relatedLengthPositions) {
        ArrayList<List<Object>> modifiedItems = new ArrayList<List<Object>>(items.size());
        for (ResourceItem item : items) {
            ArrayList<Object> modifiedValues = new ArrayList<Object>(item.getPropertyValues());
            for (Integer relatedLengthPosition : relatedLengthPositions) {
                Object value = modifiedValues.get(relatedLengthPosition);
                if (value == null) continue;
                int length = Array.getLength(value);
                modifiedValues.set(relatedLengthPosition, length);
            }
            modifiedItems.add(modifiedValues);
        }
        return modifiedItems;
    }

    @Override
    public QuerySchema getSchema() {
        return this._connection.getSchema();
    }
}

