/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyLookup;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipDescriptor;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.internal.util.ReflectionUtil;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.model.Relationship;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelatedPropertyRepository
implements RelatedPropertyLookup {
    private static final Logger _logger = LoggerFactory.getLogger(RelatedPropertyRepository.class);
    private final Map<String, RelatedPropertyDescriptor> _descriptorByRelatedProperty;

    public RelatedPropertyRepository(Collection<Class<?>> registeredQueryModels) {
        this(RelatedPropertyRepository.registerRelatedProperties(registeredQueryModels));
    }

    public RelatedPropertyRepository(Map<String, RelatedPropertyDescriptor> descriptorByRelatedProperty) {
        assert (descriptorByRelatedProperty != null);
        this._descriptorByRelatedProperty = Collections.unmodifiableMap(descriptorByRelatedProperty);
    }

    @Override
    public RelatedPropertyDescriptor getRelatedPropertyDescriptor(String modelProperty) {
        return this._descriptorByRelatedProperty.get(modelProperty);
    }

    @Override
    public Map<String, RelatedPropertyDescriptor> getRelatedPropertyDescriptors(List<String> relatedProperties) {
        if (CollectionUtils.isEmpty(relatedProperties)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, RelatedPropertyDescriptor> relatedPropertyDescriptorsByName = new LinkedHashMap<String, RelatedPropertyDescriptor>();
        for (String relatedProperty : relatedProperties) {
            RelatedPropertyDescriptor relatedPropertyDescriptor = this._descriptorByRelatedProperty.get(relatedProperty);
            if (relatedPropertyDescriptor == null) continue;
            relatedPropertyDescriptorsByName.put(relatedProperty, relatedPropertyDescriptor);
        }
        return Collections.unmodifiableMap(relatedPropertyDescriptorsByName);
    }

    @Override
    public QuerySchema calculateRelatedPropertySchema(QuerySchema schema) {
        HashMap<String, QuerySchema.PropertyInfo> propertyInfoByQualifiedName = new HashMap<String, QuerySchema.PropertyInfo>(this._descriptorByRelatedProperty.size());
        for (String property : this._descriptorByRelatedProperty.keySet()) {
            RelatedPropertyDescriptor descriptor = this._descriptorByRelatedProperty.get(property);
            try {
                this.registerRelatedPropertyInfo(propertyInfoByQualifiedName, schema, descriptor);
            }
            catch (Exception e) {
                _logger.debug("Could not register custom defined related property " + property, (Throwable)e);
            }
        }
        return QuerySchema.forProperties(propertyInfoByQualifiedName);
    }

    public static Map<Field, RelatedPropertyDescriptor> collectRelatedPropertyDescriptorByField(String resourceModel, Class<?> modelClass) {
        assert (!StringUtils.isEmpty((String)resourceModel));
        assert (modelClass != null);
        HashMap<Field, RelatedPropertyDescriptor> descriptorsByField = new HashMap<Field, RelatedPropertyDescriptor>();
        for (Field field : ReflectionUtil.getAllFields(modelClass)) {
            RelatedPropertyDescriptor descriptor;
            if (!field.isAnnotationPresent(Property.class) || field.isAnnotationPresent(Property.class) && !field.isAnnotationPresent(Relationship.class)) continue;
            try {
                descriptor = RelatedPropertyDescriptor.fromField(resourceModel, field);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException(String.format("Invalid related property declaration '%s' in class '%s'", field.getName(), modelClass.getCanonicalName()), ex);
            }
            descriptorsByField.put(field, descriptor);
        }
        return descriptorsByField;
    }

    private void registerRelatedPropertyInfo(Map<String, QuerySchema.PropertyInfo> propertyInfoByQualifiedName, QuerySchema schema, RelatedPropertyDescriptor descriptor) {
        String targetPropertyName;
        QuerySchema.PropertyInfo targetPropertyInfo;
        String relatedPropertyName = descriptor.getName();
        boolean isRelatedPropertyFilterable = true;
        for (RelationshipDescriptor relation : descriptor.getRelationships()) {
            String relationName = relation.getName();
            QuerySchema.PropertyInfo relatedHopPropertyInfo = RelatedPropertyRepository.getRelatedHopPropertyInfo(schema, relationName);
            if (relatedHopPropertyInfo == null) {
                isRelatedPropertyFilterable = false;
                break;
            }
            if (relation.isDefinedByTarget() && !relatedHopPropertyInfo.getFilterable()) {
                _logger.debug(String.format("Could not register custom defined related property '%s' as  it contains an inverse relationship hop which is not filterable '%s'.", relatedPropertyName, relationName));
                return;
            }
            isRelatedPropertyFilterable &= relatedHopPropertyInfo.getFilterable();
        }
        if ((targetPropertyInfo = RelatedPropertyRepository.getTargetPropertyInfo(schema, targetPropertyName = descriptor.getTargetName())) == null) {
            _logger.debug(String.format("Could not register custom defined related property '%s' as  it targets a non-existing property '%s'.", relatedPropertyName, targetPropertyName));
            return;
        }
        QuerySchema.PropertyInfo propertyInfo = null;
        propertyInfo = (isRelatedPropertyFilterable &= targetPropertyInfo.getFilterable()) ? QuerySchema.PropertyInfo.forFilterableProperty(targetPropertyInfo.getType()) : QuerySchema.PropertyInfo.forNonFilterableProperty();
        propertyInfoByQualifiedName.put(relatedPropertyName, propertyInfo);
    }

    private static QuerySchema.PropertyInfo getRelatedHopPropertyInfo(QuerySchema schema, String relationName) {
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName(relationName);
        QuerySchema.PropertyInfo relatedHopPropertyInfo = SchemaUtil.getPropertyInfoForQualifiedName(schema, qualifiedProperty);
        return relatedHopPropertyInfo;
    }

    private static QuerySchema.PropertyInfo getTargetPropertyInfo(QuerySchema schema, String targetPropertyName) {
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName(targetPropertyName);
        QuerySchema.PropertyInfo targetPropertyInfo = SchemaUtil.getPropertyInfoForQualifiedName(schema, qualifiedProperty);
        return targetPropertyInfo;
    }

    private static Map<String, RelatedPropertyDescriptor> registerRelatedProperties(Collection<Class<?>> modelClasses) {
        Validate.notNull(modelClasses);
        if (modelClasses.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, RelatedPropertyDescriptor> relatedProperties = new HashMap<String, RelatedPropertyDescriptor>();
        for (Class<?> modelClass : modelClasses) {
            RelatedPropertyRepository.registerRelatedProperties(modelClass, relatedProperties);
        }
        return relatedProperties;
    }

    private static void registerRelatedProperties(Class<?> modelClass, Map<String, RelatedPropertyDescriptor> relatedProperties) {
        Validate.notNull(modelClass);
        Validate.notNull(relatedProperties);
        Collection<RelatedPropertyDescriptor> relatedPropertiesDescriptors = RelatedPropertyRepository.collectRelatedPropertyDescriptors(modelClass);
        if (relatedPropertiesDescriptors.isEmpty()) {
            return;
        }
        for (RelatedPropertyDescriptor relatedProperty : relatedPropertiesDescriptors) {
            if (relatedProperties.containsKey(relatedProperty.getName())) {
                throw new IllegalArgumentException(String.format("Duplicate related property registration '%s' detected!", relatedProperty.getName()));
            }
            relatedProperties.put(relatedProperty.getName(), relatedProperty);
        }
    }

    private static Collection<RelatedPropertyDescriptor> collectRelatedPropertyDescriptors(Class<?> modelClass) {
        assert (modelClass != null);
        QueryModel modelDefinition = modelClass.getAnnotation(QueryModel.class);
        Validate.notNull((Object)modelDefinition, (String)"The provided class is not annotated with @QueryModel annotation.");
        String resourceModel = modelDefinition.value();
        return RelatedPropertyRepository.collectRelatedPropertyDescriptorByField(resourceModel, modelClass).values();
    }
}

