/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipQuery;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipResultJoin;
import com.vmware.cis.data.internal.provider.util.ResourceItemUtil;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import com.vmware.cis.data.provider.DataProvider;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RelationshipQueryExecutor {
    private static Logger _logger = LoggerFactory.getLogger(RelationshipQueryExecutor.class);

    RelationshipQueryExecutor() {
    }

    public static ResultSet executeRelationshipQueriesForSelect(String relatedPropertyName, List<RelationshipQuery> relationshipQueries, ResultSet previousResultSet, SortCriterion relatedPropertySortCriterion, List<Integer> reorderedItemsIndices, DataProvider connection) {
        RelationshipQuery lastRelationshipQuery;
        Query selectRelationshipQuery;
        ResultSet resultSetForJoin;
        assert (relatedPropertyName != null);
        assert (relationshipQueries != null);
        assert (!relationshipQueries.isEmpty());
        assert (previousResultSet != null);
        assert (reorderedItemsIndices != null);
        assert (connection != null);
        RelationshipQuery firstRelationshipQuery = relationshipQueries.get(0);
        String sourceModelJoinProperty = firstRelationshipQuery.getRelationshipJoin().getSourceJoinProperty();
        ResultSet previousSelectResult = resultSetForJoin = ResultSetUtil.extractPropertyFromResultSet(previousResultSet, sourceModelJoinProperty);
        if (relationshipQueries.size() > 1) {
            previousSelectResult = RelationshipQueryExecutor.executeRelationshipQueries(relatedPropertyName, relationshipQueries.subList(0, relationshipQueries.size() - 1), resultSetForJoin, connection);
        }
        if ((selectRelationshipQuery = (lastRelationshipQuery = relationshipQueries.get(relationshipQueries.size() - 1)).buildQueryForJoin(previousSelectResult, relatedPropertySortCriterion)) == null) {
            return null;
        }
        ResultSet selectResult = RelationshipQueryExecutor.executeRelationshipQuery(relatedPropertyName, selectRelationshipQuery, connection);
        String lastRightJoinProperty = lastRelationshipQuery.getRelationshipJoin().getTargetJoinProperty();
        ResultSet relatedResult = RelationshipResultJoin.joinResults(previousSelectResult, lastRelationshipQuery.getRelationshipJoin().getSourceJoinProperty(), true, selectResult, lastRightJoinProperty, false);
        if (relatedPropertySortCriterion != null) {
            reorderedItemsIndices.addAll(ResourceItemUtil.getResourceItemsPermutation(relatedResult, lastRightJoinProperty, selectResult, lastRightJoinProperty, SortCriterion.SortDirection.ASCENDING.equals((Object)relatedPropertySortCriterion.getSortDirection())));
        }
        return relatedResult;
    }

    public static ResultSet executeRelationshipQueriesForFilter(String relatedPropertyName, List<RelationshipQuery> relationshipQueries, Filter relatedPropertyPartialFilter, SortCriterion relatedPropertySortCriterion, DataProvider connection) {
        assert (relatedPropertyName != null);
        assert (relationshipQueries != null);
        assert (!relationshipQueries.isEmpty());
        assert (relatedPropertyPartialFilter != null);
        assert (connection != null);
        RelationshipQuery firstRelationshipQuery = relationshipQueries.get(0);
        Query filterRelationshipQuery = firstRelationshipQuery.buildQueryForFilter(relatedPropertyPartialFilter, relatedPropertySortCriterion);
        ResultSet filterResult = RelationshipQueryExecutor.executeRelationshipQuery(relatedPropertyName, filterRelationshipQuery, connection);
        if (relationshipQueries.size() == 1) {
            return filterResult;
        }
        return RelationshipQueryExecutor.executeRelationshipQueries(relatedPropertyName, relationshipQueries.subList(1, relationshipQueries.size()), filterResult, connection);
    }

    private static ResultSet executeRelationshipQueries(String relatedPropertyName, List<RelationshipQuery> relationshipQueries, ResultSet previousResultSet, DataProvider connection) {
        assert (relationshipQueries != null);
        assert (!relationshipQueries.isEmpty());
        if (previousResultSet == null) {
            return null;
        }
        ResultSet relatedResult = previousResultSet;
        for (RelationshipQuery relationshipQuery : relationshipQueries) {
            Query query = relationshipQuery.buildQueryForJoin(relatedResult, null);
            if (query == null) {
                relatedResult = null;
                break;
            }
            ResultSet relationshipResult = RelationshipQueryExecutor.executeRelationshipQuery(relatedPropertyName, query, connection);
            relatedResult = RelationshipResultJoin.joinResults(relatedResult, relationshipQuery.getRelationshipJoin().getSourceJoinProperty(), true, relationshipResult, relationshipQuery.getRelationshipJoin().getTargetJoinProperty(), true);
        }
        return relatedResult;
    }

    private static ResultSet executeRelationshipQuery(String relatedProperty, Query query, DataProvider connection) {
        ResultSet result;
        assert (connection != null);
        try {
            if (_logger.isTraceEnabled()) {
                _logger.trace("[QueryModel] Executing a generated query for the related property [ {} ]: {}", (Object)relatedProperty, (Object)query);
            }
            result = connection.executeQuery(query);
            if (_logger.isTraceEnabled()) {
                _logger.trace("[QueryModel] Received response for a generated query for the related property [ {} ]: {}", (Object)relatedProperty, (Object)query);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error while executing a query for the related property '%s': '%s'", relatedProperty, query), e);
        }
        return result;
    }
}

