/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.join;

import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ResultSetAnalyzer;
import com.vmware.cis.data.internal.provider.join.JoinOperator;
import com.vmware.cis.data.internal.provider.join.RelationalAlgebra;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class LeftJoinOperator
implements JoinOperator {
    @Override
    public ResultSet join(Collection<ResultSet> results) {
        throw new UnsupportedOperationException("LEFT JOIN for unordered result sets is not supported");
    }

    @Override
    public ResultSet joinOrderedResult(ResultSet left, ResultSet rightOrdered) {
        assert (left != null);
        assert (rightOrdered != null);
        List<Object> rightOrderedKeys = ResultSetAnalyzer.gatherModelKeysOrdered(rightOrdered);
        Set<Object> leftUnorderedKeys = ResultSetAnalyzer.gatherModelKeys(left);
        rightOrderedKeys.retainAll(leftUnorderedKeys);
        if (!rightOrderedKeys.isEmpty()) {
            leftUnorderedKeys.removeAll(rightOrderedKeys);
            rightOrderedKeys.addAll(leftUnorderedKeys);
        }
        Collection<Object> modelKeys = rightOrderedKeys.isEmpty() ? leftUnorderedKeys : rightOrderedKeys;
        List<ResultSet> results = Arrays.asList(left, rightOrdered);
        ResultSet joinResult = RelationalAlgebra.joinAndSelect(results, modelKeys);
        return joinResult;
    }
}

