/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.join;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ResultSetAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RelationalAlgebra {
    public static ResultSet joinAndSelect(Collection<ResultSet> results, Collection<Object> selection) {
        assert (results != null);
        assert (!results.isEmpty());
        List<String> projection = ResultSetAnalyzer.gatherReturnedPropertyNames(results);
        return RelationalAlgebra.joinSelectAndProject(results, selection, projection);
    }

    public static ResultSet joinSelectAndProject(Collection<ResultSet> results, Collection<Object> selection, List<String> projection) {
        assert (results != null);
        assert (!results.isEmpty());
        assert (projection != null);
        assert (!projection.isEmpty());
        Map<Object, Map<String, Object>> propValByNameByKey = null;
        if (!projection.isEmpty() || selection == null) {
            propValByNameByKey = RelationalAlgebra.mapPropertyValuesByNameByModelKey(results);
        }
        ArrayList<List<Object>> joinedItems = new ArrayList<List<Object>>();
        Collection<Object> modelKeys = selection != null ? selection : propValByNameByKey.keySet();
        for (Object modelKey : modelKeys) {
            ArrayList<Object> propertyValues = new ArrayList<Object>(projection.size());
            Map<String, Object> propertyValueByName = propValByNameByKey.get(modelKey);
            for (String property : projection) {
                Object propertyValue = propertyValueByName.get(property);
                propertyValues.add(propertyValue);
            }
            joinedItems.add(propertyValues);
        }
        ResultSet result = ResultSet.Builder.properties(projection).items(joinedItems).totalCount(joinedItems.size()).build();
        return result;
    }

    private static Map<Object, Map<String, Object>> mapPropertyValuesByNameByModelKey(Collection<ResultSet> results) {
        HashMap<Object, Map<String, Object>> propValByNameByModelKey = new HashMap<Object, Map<String, Object>>();
        for (ResultSet resultSet : results) {
            for (ResourceItem item : resultSet.getItems()) {
                Object modelKey = item.getKey();
                assert (modelKey != null);
                Iterator<String> nameIterator = resultSet.getProperties().iterator();
                Iterator<Object> valueIterator = item.getPropertyValues().iterator();
                while (nameIterator.hasNext()) {
                    String propertyName = nameIterator.next();
                    Object propertyValue = valueIterator.next();
                    HashMap<String, Object> propValByName = (HashMap<String, Object>)propValByNameByModelKey.get(modelKey);
                    if (propValByName == null) {
                        propValByName = new HashMap<String, Object>();
                        propValByNameByModelKey.put(modelKey, propValByName);
                    }
                    propValByName.put(propertyName, propertyValue);
                }
            }
        }
        return propValByNameByModelKey;
    }
}

