/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.merge;

import com.vmware.cis.data.internal.provider.merge.SequenceMergePolicy;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public final class OrderedSequenceMergePolicy<T>
implements SequenceMergePolicy<T> {
    private final Comparator<T> _itemComparator;

    public OrderedSequenceMergePolicy(Comparator<T> itemComparator) {
        assert (itemComparator != null);
        this._itemComparator = itemComparator;
    }

    @Override
    public Iterator<T> merge(Collection<Iterator<T>> sequences) {
        assert (sequences != null);
        final PriorityQueue<T> queue = new PriorityQueue<T>(sequences.size(), new ItemContextComparator<T>(this._itemComparator));
        for (Iterator<T> itemIterator : sequences) {
            if (!itemIterator.hasNext()) continue;
            queue.add(new ItemElement<T>(itemIterator));
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public T next() {
                ItemElement head = (ItemElement)queue.remove();
                if (head.itemIterator.hasNext()) {
                    queue.add(new ItemElement(head.itemIterator));
                }
                return head.item;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static final class ItemContextComparator<T>
    implements Comparator<ItemElement<T>> {
        private final Comparator<T> _itemComparator;

        public ItemContextComparator(Comparator<T> itemComparator) {
            assert (itemComparator != null);
            this._itemComparator = itemComparator;
        }

        @Override
        public int compare(ItemElement<T> o1, ItemElement<T> o2) {
            assert (o1 != null);
            assert (o2 != null);
            return this._itemComparator.compare(o1.item, o2.item);
        }
    }

    private static class ItemElement<T> {
        final T item;
        final Iterator<T> itemIterator;

        public ItemElement(Iterator<T> itemIterator) {
            assert (itemIterator != null);
            T nextItem = itemIterator.next();
            assert (nextItem != null);
            this.item = nextItem;
            this.itemIterator = itemIterator;
        }
    }
}

