/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.profiler;

import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.cis.data.internal.provider.DataProviderConnection;
import com.vmware.cis.data.internal.provider.DataProviderConnector;
import com.vmware.cis.data.internal.provider.profiler.OperationThresholdDataProvider;
import com.vmware.cis.data.provider.DataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OperationThresholdDataProviderConnector
implements DataProviderConnector {
    private static final Logger _logger = LoggerFactory.getLogger(OperationThresholdDataProviderConnector.class);
    private final DataProviderConnector _providerConnector;
    private final long _loginThreshold;
    private final long _operationThreshold;

    public OperationThresholdDataProviderConnector(DataProviderConnector providerConnector, long loginThreshold, long operationThreshold) {
        assert (providerConnector != null);
        assert (loginThreshold >= 0L);
        assert (operationThreshold >= 0L);
        this._providerConnector = providerConnector;
        this._loginThreshold = loginThreshold;
        this._operationThreshold = operationThreshold;
    }

    @Override
    public DataProviderConnection getConnection(AuthenticationTokenSource authn) {
        long startTime = System.currentTimeMillis();
        final DataProviderConnection profiledConnection = this._providerConnector.getConnection(authn);
        long executionTime = System.currentTimeMillis() - startTime;
        if (executionTime > this._loginThreshold) {
            _logger.warn("Slow login detected for ({}): {} ms.", (Object)this._providerConnector.toString(), (Object)executionTime);
        }
        return new DataProviderConnection(){

            @Override
            public void close() throws Exception {
                profiledConnection.close();
            }

            @Override
            public DataProvider getDataProvider() {
                return new OperationThresholdDataProvider(profiledConnection.getDataProvider(), OperationThresholdDataProviderConnector.this._operationThreshold);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._providerConnector.toString() + ")";
    }
}

