/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.property;

import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.model.PropertyProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PropertyProviderMethod {
    public static final String PROPERTY_PROVIDER_METHOD_NAME_PREFIX = "get";
    private static Logger _logger = LoggerFactory.getLogger(PropertyProviderMethod.class);
    private final Object _obj;
    private final Method _method;
    private final String _propertyName;

    public static Collection<PropertyProviderMethod> forPropertyProvider(Object propertyProvider) {
        assert (propertyProvider != null);
        ArrayList<PropertyProviderMethod> providerMethods = new ArrayList<PropertyProviderMethod>();
        for (Method method : propertyProvider.getClass().getMethods()) {
            PropertyProviderMethod providerMethod;
            if (!method.isAnnotationPresent(PropertyProvider.class)) continue;
            try {
                PropertyProviderMethod.validatePropertyProviderMethod(method);
                String propertyName = PropertyProviderMethod.getPropertyName(method);
                providerMethod = new PropertyProviderMethod(propertyProvider, method, propertyName);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException(String.format("Invalid property provider method '%s' in %s", method.getName(), propertyProvider.getClass().getCanonicalName()), ex);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("Register method '{}' from property provider '{}' for property '{}'", new Object[]{method.getName(), propertyProvider.getClass().getCanonicalName(), providerMethod.getPropertyName()});
            }
            providerMethods.add(providerMethod);
        }
        return providerMethods;
    }

    private static void validatePropertyProviderMethod(Method method) {
        assert (method != null);
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Property provider method must be public.");
        }
        if (!Collection.class.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException("Property provider method must return an instance of java.util.Collection");
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("Property provider method must accept a single parameter");
        }
        if (Collection.class != params[0]) {
            throw new IllegalArgumentException("Property provider method must accept a parameter of class java.util.Collection");
        }
    }

    private static String getPropertyName(Method method) {
        assert (method != null);
        assert (method.isAnnotationPresent(PropertyProvider.class));
        PropertyProvider providerAnnotation = method.getAnnotation(PropertyProvider.class);
        String annotationValue = providerAnnotation.value();
        Validate.notEmpty((String)annotationValue, (String)"@PropertyProvider annotation must contain model-qualified property name");
        if (annotationValue.indexOf(47) > 0) {
            return annotationValue;
        }
        String model = annotationValue;
        String methodName = method.getName();
        if (!methodName.startsWith(PROPERTY_PROVIDER_METHOD_NAME_PREFIX)) {
            throw new IllegalArgumentException(String.format("Property provider method name must start with 'get' prefix: '%s'", methodName));
        }
        if (methodName.codePointCount(0, methodName.length()) != methodName.length()) {
            throw new IllegalArgumentException(String.format("Property provider method name must use only ASCII characters: '%s'", methodName));
        }
        String rawPropertyName = methodName.substring(PROPERTY_PROVIDER_METHOD_NAME_PREFIX.length());
        if (rawPropertyName.isEmpty()) {
            throw new IllegalArgumentException(String.format("Derived property method name must contain property name after the 'get' prefix: '%s'", methodName));
        }
        String simpleProperty = Character.toLowerCase(rawPropertyName.charAt(0)) + rawPropertyName.substring(1);
        return QualifiedProperty.forModelAndSimpleProperty(model, simpleProperty).toString();
    }

    private PropertyProviderMethod(Object obj, Method method, String propertyName) {
        assert (obj != null);
        assert (method != null);
        assert (propertyName != null);
        this._obj = obj;
        this._method = method;
        this._propertyName = propertyName;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Collection<?> getPropertyValuesForKeys(Collection<?> keys) {
        Object result;
        assert (keys != null);
        assert (!keys.isEmpty());
        if (_logger.isTraceEnabled()) {
            _logger.trace("Invoking property provider method '{}' of '{}' for resources: {}", new Object[]{this._method.getName(), this._obj.getClass().getCanonicalName(), keys});
        }
        try {
            result = this._method.invoke(this._obj, keys);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(String.format("Property provider method '%s' of '%s' is inaccessible", this._method.getName(), this._obj.getClass().getCanonicalName()), ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException(String.format("Property provider method '%s' of '%s' threw exception", this._method.getName(), this._obj.getClass().getCanonicalName()), ex.getTargetException());
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace("Property provider method '{}' of '{}' returned: {}", new Object[]{this._method.getName(), this._obj.getClass().getCanonicalName(), result});
        }
        if (result == null) {
            throw new IllegalStateException(String.format("Property provider method '%s' of '%s' returned null", this._method.getName(), this._obj.getClass().getCanonicalName()));
        }
        if (!(result instanceof Collection)) {
            throw new IllegalStateException(String.format("Property provider method '%s' of '%s' returned %s instead of java.util.Collection", this._method.getName(), this._obj.getClass().getCanonicalName(), result.getClass()));
        }
        Collection values = (Collection)result;
        if (values.size() != keys.size()) {
            throw new IllegalStateException(String.format("Property provider method '%s' of '%s' returned %d property values instead of %d", this._method.getName(), this._obj.getClass().getCanonicalName(), values.size(), keys.size()));
        }
        return values;
    }

    public String toString() {
        return this._propertyName;
    }
}

