/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.util;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.util.ResourceItemUtil;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.cis.data.internal.util.UnqualifiedProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryQualifier {
    private final QuerySchema _dataProviderSchema;

    public QueryQualifier(QuerySchema dataProviderSchma) {
        this._dataProviderSchema = dataProviderSchma;
    }

    public QualifierContext qualifyQuery(Query query) {
        assert (query != null);
        List<String> properties = this.qualifySelectClause(query);
        Map<String, String> propertiesMapping = this.createMapping(query.getProperties(), properties);
        Filter filter = null;
        List<PropertyPredicate> propertyPredicates = this.qualifyWhereClause(query);
        if (!propertyPredicates.isEmpty()) {
            filter = new Filter(propertyPredicates, query.getFilter().getOperator());
        }
        List<SortCriterion> sortCriteria = this.qualifyOrderByClause(query);
        Collection<String> resourceModels = query.getResourceModels();
        Query.Builder builder = QueryCopy.copyAndSelect(query, properties).from(resourceModels).where(filter).orderBy(sortCriteria);
        return new QualifierContext(builder.build(), propertiesMapping);
    }

    public ResultSet unqualifyResultSet(ResultSet resultSet, QualifierContext context) {
        assert (resultSet != null);
        assert (context != null);
        ArrayList<String> properties = new ArrayList<String>(resultSet.getProperties().size());
        for (String qualifiedProperty : resultSet.getProperties()) {
            String originalProperty = (String)context._originalByQualifiedProperties.get(qualifiedProperty);
            if (originalProperty == null) {
                originalProperty = qualifiedProperty;
            }
            properties.add(originalProperty);
        }
        return ResultSet.Builder.properties(properties).items(ResourceItemUtil.getValues(resultSet.getItems())).totalCount(resultSet.getTotalCount()).build();
    }

    private List<String> qualifySelectClause(Query query) {
        ArrayList<String> properties = new ArrayList<String>(query.getProperties().size());
        for (String property : query.getProperties()) {
            String qualifiedProperty = this.qualifyProperty(property, query.getResourceModels());
            properties.add(qualifiedProperty);
        }
        return properties;
    }

    private List<PropertyPredicate> qualifyWhereClause(Query query) {
        if (query.getFilter() == null) {
            return new ArrayList<PropertyPredicate>();
        }
        ArrayList<PropertyPredicate> propertyPredicates = new ArrayList<PropertyPredicate>(query.getFilter().getCriteria().size());
        for (PropertyPredicate pp : query.getFilter().getCriteria()) {
            String qualifiedProperty = this.qualifyProperty(pp.getProperty(), query.getResourceModels());
            PropertyPredicate propertyPredicate = new PropertyPredicate(qualifiedProperty, pp.getOperator(), pp.getComparableValue(), pp.isIgnoreCase());
            propertyPredicates.add(propertyPredicate);
        }
        return propertyPredicates;
    }

    private List<SortCriterion> qualifyOrderByClause(Query query) {
        ArrayList<SortCriterion> sortCriteria = new ArrayList<SortCriterion>(query.getSortCriteria().size());
        for (SortCriterion sc : query.getSortCriteria()) {
            String qualifiedProperty = this.qualifyProperty(sc.getProperty(), query.getResourceModels());
            SortCriterion sortCriterion = new SortCriterion(qualifiedProperty, sc.getSortDirection(), sc.isIgnoreCase());
            sortCriteria.add(sortCriterion);
        }
        return sortCriteria;
    }

    public static Collection<String> getFromClause(List<String> properties, Filter filter, List<SortCriterion> sortCriteria) {
        HashSet<String> models = new HashSet<String>();
        for (String property : properties) {
            QueryQualifier.addModel(property, models);
        }
        if (filter != null) {
            for (PropertyPredicate predicate : filter.getCriteria()) {
                QueryQualifier.addModel(predicate.getProperty(), models);
            }
        }
        if (sortCriteria != null) {
            for (SortCriterion sortCriterion : sortCriteria) {
                QueryQualifier.addModel(sortCriterion.getProperty(), models);
            }
        }
        return new ArrayList<String>(models);
    }

    public static void addModel(String property, Set<String> models) {
        if (PropertyUtil.isSpecialProperty(property)) {
            return;
        }
        models.add(QualifiedProperty.forQualifiedName(property).getResourceModel());
    }

    private String qualifyProperty(String property, Collection<String> models) {
        assert (models != null);
        if (PropertyUtil.isSpecialProperty(property)) {
            return property;
        }
        if (QualifiedProperty.isSyntacticallyQualified(property)) {
            QualifiedProperty qp = QualifiedProperty.forQualifiedName(property);
            if (this.modelExists(qp.getResourceModel())) {
                if (this.propertyExists(qp.getResourceModel(), qp.getSimpleProperty())) {
                    return property;
                }
                throw new IllegalArgumentException("Property " + qp.getSimpleProperty() + " is not registered for model " + qp.getResourceModel());
            }
            if (!qp.isVmodl1()) {
                throw new IllegalArgumentException("Resource model " + qp.getResourceModel() + " is not registered");
            }
        }
        QualifiedProperty qualifiedProperty = null;
        for (String model : models) {
            QualifiedProperty currentProperty = QualifiedProperty.forModelAndSimpleProperty(model, property);
            if (!this.propertyExists(model, property)) continue;
            if (qualifiedProperty == null) {
                qualifiedProperty = currentProperty;
                continue;
            }
            throw new IllegalArgumentException(String.format("Unqualified property '%s' is ambiguous - it appears both in  model '%s' and model '%s'", property, qualifiedProperty.getResourceModel(), currentProperty.getResourceModel()));
        }
        if (qualifiedProperty == null) {
            throw new IllegalArgumentException("Could not qualify property: " + property);
        }
        return qualifiedProperty.toString();
    }

    private boolean propertyExists(String model, String property) {
        QuerySchema.ModelInfo modelInfo = this._dataProviderSchema.getModels().get(model);
        if (modelInfo == null) {
            return false;
        }
        QuerySchema.PropertyInfo propertyInfo = modelInfo.getProperties().get(UnqualifiedProperty.getRootProperty(property));
        return propertyInfo != null;
    }

    private boolean modelExists(String model) {
        QuerySchema.ModelInfo modelInfo = this._dataProviderSchema.getModels().get(model);
        return modelInfo != null;
    }

    private Map<String, String> createMapping(List<String> originalProperties, List<String> qualifiedProperties) {
        assert (originalProperties != null);
        assert (qualifiedProperties != null);
        assert (originalProperties.size() == qualifiedProperties.size());
        HashMap<String, String> propertiesMapping = new HashMap<String, String>();
        Iterator<String> iterator = originalProperties.iterator();
        for (String qualifiedProperty : qualifiedProperties) {
            String originalProperty;
            String storedProperty = propertiesMapping.put(qualifiedProperty, originalProperty = iterator.next());
            if (storedProperty == null) continue;
            if (storedProperty.equals(originalProperty)) {
                throw new IllegalArgumentException(String.format("Property '%s' specified multiple times in SELECT", originalProperty));
            }
            throw new IllegalArgumentException(String.format("Both property '%s' and %s are qualified as %s", storedProperty, originalProperty, qualifiedProperty));
        }
        return propertiesMapping;
    }

    public class QualifierContext {
        private final Map<String, String> _originalByQualifiedProperties;
        private final Query _qualifiedQuery;

        QualifierContext(Query qualifiedQuery, Map<String, String> originalByQualifiedProperties) {
            assert (qualifiedQuery != null);
            assert (originalByQualifiedProperties != null);
            this._qualifiedQuery = qualifiedQuery;
            this._originalByQualifiedProperties = originalByQualifiedProperties;
        }

        public Query getQualifiedQuery() {
            return this._qualifiedQuery;
        }
    }
}

