/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.util;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ResultSetAnalyzer;
import com.vmware.cis.data.internal.provider.util.ResourceItemUtil;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyValueByNameViaIndexMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class ResultSetUtil {
    public static ResultSet extractPropertyFromResultSet(ResultSet result, String propertyName) {
        assert (result != null);
        assert (propertyName != null);
        List<String> resultProperties = result.getProperties();
        int propertyIndex = resultProperties.indexOf(propertyName);
        if (propertyIndex < 0) {
            return ResultSet.EMPTY_RESULT;
        }
        ArrayList<List<Object>> newResourceItems = new ArrayList<List<Object>>(result.getItems().size());
        for (ResourceItem item : result.getItems()) {
            Object propertyValue = item.getPropertyValues().get(propertyIndex);
            newResourceItems.add(Collections.singletonList(propertyValue));
        }
        return ResultSet.Builder.properties(propertyName).items(newResourceItems).totalCount(result.getTotalCount()).build();
    }

    public static ResultSet removePropertyFromResultSet(ResultSet result, String propertyName) {
        assert (result != null);
        assert (propertyName != null);
        ArrayList<String> resultProperties = new ArrayList<String>(result.getProperties());
        int propertyIndex = resultProperties.indexOf(propertyName);
        if (propertyIndex < 0) {
            return result;
        }
        if (resultProperties.size() == 1) {
            return ResultSet.EMPTY_RESULT;
        }
        resultProperties.remove(propertyIndex);
        ArrayList<List<Object>> newResourceItems = new ArrayList<List<Object>>(result.getItems().size());
        for (ResourceItem item : result.getItems()) {
            ArrayList<Object> newPropertyValues = new ArrayList<Object>(item.getPropertyValues());
            newPropertyValues.remove(propertyIndex);
            newResourceItems.add(newPropertyValues);
        }
        return ResultSet.Builder.properties(resultProperties).items(newResourceItems).totalCount(result.getTotalCount()).build();
    }

    public static List<Object> extractNotNullPropertyValues(ResultSet resultSet, String propertyName) {
        Validate.notNull((Object)resultSet);
        Validate.notEmpty((String)propertyName);
        if (resultSet.getItems().isEmpty()) {
            return Collections.emptyList();
        }
        List<String> resultProperties = resultSet.getProperties();
        int propertyIndex = resultProperties.lastIndexOf(propertyName);
        if (propertyIndex < 0) {
            throw new IllegalArgumentException(String.format("The given join property [%s] is not among the result properties!", propertyIndex));
        }
        List<Object> propertyValues = ResultSetAnalyzer.gatherPropertyValuesByIndexOrdered(resultSet, propertyIndex);
        propertyValues = ResourceItemUtil.flattenNotNullPropertyValues(propertyValues);
        return Collections.unmodifiableList(propertyValues);
    }

    public static ResultSet reorderResultByPropertyValuesOrder(ResultSet result, String orderProperty, List<Object> orderedValues, boolean notMatchedItemsFirst) {
        assert (result != null);
        assert (orderProperty != null);
        assert (orderedValues != null);
        List<ResourceItem> resultItems = result.getItems();
        if (resultItems.isEmpty() || orderedValues.isEmpty()) {
            return result;
        }
        int orderPropertyIndex = result.getProperties().lastIndexOf(orderProperty);
        if (orderPropertyIndex < 0) {
            throw new IllegalArgumentException(String.format("The given property [%s] is not among the result properties!", orderPropertyIndex));
        }
        LinkedHashMap orderedResourceItemsByValue = new LinkedHashMap();
        ArrayList<ResourceItem> notMatchedResourceItems = new ArrayList<ResourceItem>();
        for (Object orderValue : orderedValues) {
            orderedResourceItemsByValue.put(orderValue, new ArrayList());
        }
        for (ResourceItem resultItem : resultItems) {
            Object propertyValue = resultItem.getPropertyValues().get(orderPropertyIndex);
            List orderedResourceItems = (List)orderedResourceItemsByValue.get(propertyValue);
            if (orderedResourceItems != null) {
                orderedResourceItems.add(resultItem);
                continue;
            }
            notMatchedResourceItems.add(resultItem);
        }
        ArrayList<ResourceItem> reorderedResultItems = new ArrayList<ResourceItem>(resultItems.size());
        for (List orderedResourceItems : orderedResourceItemsByValue.values()) {
            reorderedResultItems.addAll(orderedResourceItems);
        }
        if (notMatchedItemsFirst) {
            reorderedResultItems.addAll(0, notMatchedResourceItems);
        } else {
            reorderedResultItems.addAll(notMatchedResourceItems);
        }
        return ResultSet.Builder.properties(result.getProperties()).items(ResourceItemUtil.getValues(reorderedResultItems)).totalCount(result.getTotalCount()).build();
    }

    public static ResultSet reorderResultByIndices(ResultSet result, List<Integer> resourceItemsIndexPermutation) {
        assert (result != null);
        assert (resourceItemsIndexPermutation != null);
        List<ResourceItem> resultItems = result.getItems();
        if (resultItems.isEmpty() || resourceItemsIndexPermutation.isEmpty()) {
            return result;
        }
        List<ResourceItem> reorderedItems = ResourceItemUtil.reorderResourceItems(resultItems, resourceItemsIndexPermutation);
        return ResultSet.Builder.properties(result.getProperties()).items(ResourceItemUtil.getValues(reorderedItems)).totalCount(result.getTotalCount()).build();
    }

    public static ResultSet applyLimitAndOffset(ResultSet resultSet, int limit, int offset) {
        List<ResourceItem> boundedItems;
        if (resultSet == null) {
            return resultSet;
        }
        if (limit == 0) {
            return ResultSet.Builder.properties(new String[0]).totalCount(resultSet.getTotalCount()).build();
        }
        if (limit < 0 && offset == 0) {
            return resultSet;
        }
        assert (offset >= 0);
        List<ResourceItem> items = resultSet.getItems();
        if (offset > items.size()) {
            boundedItems = Collections.emptyList();
        } else {
            int endIndex;
            if (limit < 0 || limit + offset > items.size()) {
                if (offset == 0) {
                    return resultSet;
                }
                endIndex = items.size();
            } else {
                endIndex = limit + offset;
            }
            boundedItems = items.subList(offset, endIndex);
        }
        ResultSet boundedResult = ResultSet.Builder.properties(resultSet.getProperties()).items(ResourceItemUtil.getValues(boundedItems)).totalCount(resultSet.getTotalCount()).build();
        return boundedResult;
    }

    public static ResultSet project(ResultSet result, List<String> projection) {
        assert (result != null);
        assert (projection != null);
        if (result.getProperties().equals(projection)) {
            return result;
        }
        if (projection.isEmpty()) {
            return ResultSet.Builder.properties(Collections.emptyList()).totalCount(result.getTotalCount()).build();
        }
        ResourceItemPropertyValueByNameViaIndexMap propertyByName = new ResourceItemPropertyValueByNameViaIndexMap(result.getProperties());
        ArrayList<List<Object>> projectedItems = new ArrayList<List<Object>>(result.getItems().size());
        for (ResourceItem item : result.getItems()) {
            ArrayList<Object> values = new ArrayList<Object>(projection.size());
            for (String property : projection) {
                Object value = propertyByName.getValue(property, item);
                values.add(value);
            }
            projectedItems.add(values);
        }
        return ResultSet.Builder.properties(projection).items(projectedItems).totalCount(result.getTotalCount()).build();
    }
}

