/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.util.filter;

import org.apache.commons.lang.Validate;

public final class OperatorLikeEvaluator {
    private static final char WILDCARD_CHAR = '*';
    private static final char ESCAPE_CHAR = '\\';

    public static boolean evalLike(String propertyValue, String comparableTemplate) {
        Validate.notNull((Object)propertyValue);
        Validate.notNull((Object)comparableTemplate);
        StringMatchingInfo info = OperatorLikeEvaluator.analyzeTemplate(comparableTemplate);
        StringMatchingMode mode = info.getMode();
        String searchText = info.getSearchText();
        switch (mode) {
            case StartsWith: {
                return propertyValue.startsWith(searchText);
            }
            case EndsWith: {
                return propertyValue.endsWith(searchText);
            }
            case Contains: {
                return propertyValue.contains(searchText);
            }
            case Exact: {
                return propertyValue.equals(searchText);
            }
        }
        throw new IllegalStateException("Unimplemented string matching mode: " + (Object)((Object)mode));
    }

    public static StringMatchingInfo analyzeTemplate(String template) {
        Validate.notNull((Object)template, (String)"Comparable text template is required");
        if (template.equals("*") || template.equals("**")) {
            throw new IllegalArgumentException("Comparable text template must contain non-wildcard characters: " + template);
        }
        boolean startsWithWildCard = false;
        boolean endsWithWildCard = false;
        StringBuilder unescaped = new StringBuilder(template.length());
        boolean isEscaped = false;
        int lastIndex = template.length() - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            char ch = template.charAt(i);
            if (isEscaped) {
                unescaped.append(ch);
                isEscaped = false;
                continue;
            }
            if (ch == '\\') {
                isEscaped = true;
                continue;
            }
            if (ch == '*') {
                if (i == 0) {
                    startsWithWildCard = true;
                    continue;
                }
                if (i == lastIndex) {
                    endsWithWildCard = true;
                    continue;
                }
                throw new IllegalArgumentException("Wildcard used in the middle of comparable value");
            }
            unescaped.append(ch);
        }
        StringMatchingMode matchingMode = OperatorLikeEvaluator.getStringMatchingMode(startsWithWildCard, endsWithWildCard);
        return new StringMatchingInfo(matchingMode, unescaped.toString());
    }

    private static StringMatchingMode getStringMatchingMode(boolean startsWithWildCard, boolean endsWithWildCard) {
        if (startsWithWildCard) {
            if (endsWithWildCard) {
                return StringMatchingMode.Contains;
            }
            return StringMatchingMode.EndsWith;
        }
        if (endsWithWildCard) {
            return StringMatchingMode.StartsWith;
        }
        return StringMatchingMode.Exact;
    }

    public static final class StringMatchingInfo {
        private final StringMatchingMode _matchingMode;
        private final String _searchText;

        StringMatchingInfo(StringMatchingMode matchingMode, String searchText) {
            assert (matchingMode != null);
            assert (searchText != null);
            this._matchingMode = matchingMode;
            this._searchText = searchText;
        }

        public StringMatchingMode getMode() {
            return this._matchingMode;
        }

        public String getSearchText() {
            return this._searchText;
        }
    }

    public static enum StringMatchingMode {
        StartsWith,
        EndsWith,
        Contains,
        Exact;

    }
}

