/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.util;

import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class FixedAuthenticationTokenSource
implements AuthenticationTokenSource {
    private final SamlToken _token;
    private final PrivateKey _confirmationKey;

    public FixedAuthenticationTokenSource(SamlToken token, PrivateKey confirmationKey) {
        Validate.notNull((Object)token, (String)"Argument `token' is required.");
        if (token.getConfirmationType() == ConfirmationType.HOLDER_OF_KEY) {
            Validate.notNull((Object)confirmationKey, (String)"Argument `confirmationKey' for holder-of-key tokens.");
        }
        this._token = token;
        this._confirmationKey = confirmationKey;
    }

    @Override
    public SamlToken getAuthenticationToken() {
        return this._token;
    }

    @Override
    public PrivateKey getConfirmationKey() {
        return this._confirmationKey;
    }

    public boolean equals(Object right) {
        if (right instanceof FixedAuthenticationTokenSource) {
            FixedAuthenticationTokenSource other = (FixedAuthenticationTokenSource)right;
            return this._token.equals((Object)other._token) && ObjectUtils.equals((Object)this._confirmationKey, (Object)other._confirmationKey);
        }
        boolean areEqual = false;
        return areEqual;
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 31).append((Object)this._token).append((Object)this._confirmationKey).toHashCode();
    }
}

