/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.util;

import org.apache.commons.lang.Validate;
import org.slf4j.MDC;

public final class QueryMarker {
    private static final String QUERY_ID_KEY = "queryId";
    private static final String QUERY_TRACING_KEY = "queryExtendedTracing";
    private static final String TRACING_ENABLED = "enabled";

    public static void setQueryId(String queryId) {
        Validate.notEmpty((String)queryId);
        MDC.put((String)QUERY_ID_KEY, (String)queryId);
    }

    public static String getQueryId() {
        return MDC.get((String)QUERY_ID_KEY);
    }

    public static void clearQueryId() {
        MDC.remove((String)QUERY_ID_KEY);
    }

    public static void enableQueryTracing() {
        MDC.put((String)QUERY_TRACING_KEY, (String)TRACING_ENABLED);
    }

    public static void disableQueryTracing() {
        MDC.remove((String)QUERY_TRACING_KEY);
    }

    public static boolean isExtendedTracingEnabled() {
        return TRACING_ENABLED == MDC.get((String)QUERY_TRACING_KEY);
    }
}

