/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.provider.registry;

import com.vmware.cis.data.provider.registry.PropertyProviderLookup;
import com.vmware.cis.data.provider.registry.PropertyProviderRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.Validate;

public final class PropertyProviderConcurrentCollection
implements PropertyProviderRegistry,
PropertyProviderLookup {
    private final CopyOnWriteArrayList<Object> _propertyProviders = new CopyOnWriteArrayList();

    @Override
    public void register(Object propertyProvider) {
        Validate.notNull((Object)propertyProvider);
        boolean added = this._propertyProviders.addIfAbsent(propertyProvider);
        if (!added) {
            throw new IllegalArgumentException("Already registered: " + propertyProvider);
        }
    }

    @Override
    public void unregister(Object propertyProvider) {
        Validate.notNull((Object)propertyProvider);
        this._propertyProviders.remove(propertyProvider);
    }

    @Override
    public Collection<Object> get() {
        return Collections.unmodifiableCollection(this._propertyProviders);
    }
}

