/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.provider.registry;

import com.vmware.cis.data.provider.registry.PropertyProviderRegistry;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyProviderRegistrar {
    private static Logger _logger = LoggerFactory.getLogger(PropertyProviderRegistrar.class);
    private final PropertyProviderRegistry _registry;
    private final Object _propertyProvider;

    public PropertyProviderRegistrar(PropertyProviderRegistry registry, Object propertyProvider) {
        Validate.notNull((Object)registry);
        Validate.notNull((Object)propertyProvider);
        this._registry = registry;
        this._propertyProvider = propertyProvider;
    }

    public void register() {
        this._registry.register(this._propertyProvider);
        _logger.info("Registered property provider '{}'", (Object)this._propertyProvider.getClass().getCanonicalName());
    }

    public void unregister() {
        this._registry.unregister(this._propertyProvider);
        _logger.info("Unregistered property provider '{}'", (Object)this._propertyProvider.getClass().getCanonicalName());
    }
}

