/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cdc.internal.adapters.pc;

import com.vmware.cdc.ChangeList;
import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.provider.ChangeLogRecorder;
import com.vmware.cdc.provider.ChangeRecorder;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorChangeLog;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorFacade;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorFilters;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticator;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiSession;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.Session;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GlobalPropertyCollectorChangeLog
implements PropertyCollectorChangeLog {
    private static Logger _logger = LoggerFactory.getLogger(GlobalPropertyCollectorChangeLog.class);
    private static final int DEFAULT_PC_WAIT_PERIOD_IN_SEC = 300;
    private static final int DEFAULT_INITIAL_RETRY_DELAY_IN_SEC = 10;
    private static final int DEFAULT_DELAYED_RETRY_ATTEMPTS_COUNT = 5;
    private final DelayedRetry _nonFatalRetry = new DelayedRetry(10, 5);
    private final VmomiAuthenticator _authenticator;
    private final AuthenticationTokenSource _credentials;
    private final VmodlContext _vmodlContext;
    private final Client _vlsiClient;
    private final AtomicReference<VmomiSession> _vlsiSession = new AtomicReference();
    private final PropertyCollectorFilters _pcFiltersFactory;
    private volatile PropertyCollectorFacade _propertyCollectorFacade;
    private volatile ChangeLog _changeLog;
    private volatile boolean _isAlive = false;
    private final ExecutorService _executor = Executors.newFixedThreadPool(1);

    GlobalPropertyCollectorChangeLog(VmomiAuthenticator authenticator, AuthenticationTokenSource credentials, VmodlContext vmodlContext, Client vlsiClient, PropertyCollectorFilters pcFiltersFactory) {
        assert (authenticator != null);
        assert (credentials != null);
        assert (vmodlContext != null);
        assert (vlsiClient != null);
        assert (pcFiltersFactory != null);
        this._authenticator = authenticator;
        this._credentials = credentials;
        this._vmodlContext = vmodlContext;
        this._vlsiClient = vlsiClient;
        this._pcFiltersFactory = pcFiltersFactory;
        ChangeLogRecorder changeLogRecorder = ChangeLogRecorder.forCircularChangeLog();
        this._changeLog = changeLogRecorder.getLog();
        this.schedulePcLongPolling(changeLogRecorder.getRecorder());
    }

    public ChangeList getChanges(String sequenceToken) throws SequenceExpiredException {
        _logger.debug("[PC] Get changes with sequence [{}]", (Object)sequenceToken);
        ChangeList changes = this._changeLog.getChanges(sequenceToken);
        _logger.debug("[PC] Changes requested by token [{}], returned [{}] number of changes with token [{}]", new Object[]{sequenceToken, changes.getChanges().size(), changes.getSequence()});
        _logger.trace("[PC] Returned changes: {}", (Object)changes.getChanges());
        return changes;
    }

    public String getCurrentSequence() {
        String currSequence = this._changeLog.getCurrentSequence();
        _logger.debug("[PC] Get current sequence: {}", (Object)currSequence);
        return currSequence;
    }

    @Override
    public void close() {
        this._isAlive = false;
        this._executor.shutdown();
        if (this._propertyCollectorFacade != null) {
            this._propertyCollectorFacade.destroy();
            this._propertyCollectorFacade = null;
        }
        this.closeConnection();
    }

    boolean isAlive() {
        return this._isAlive;
    }

    private void schedulePcLongPolling(final ChangeRecorder changeRecorder) {
        this._isAlive = true;
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                GlobalPropertyCollectorChangeLog.this.pollForChanges(changeRecorder);
            }
        });
    }

    private void pollForChanges(ChangeRecorder initChangeRecorder) {
        try {
            ChangeRecorder changeRecorder = initChangeRecorder;
            this._propertyCollectorFacade = this.createPropertyCollectorFacade();
            String pcVersion = this._propertyCollectorFacade.getVersion();
            while (this._isAlive) {
                boolean retryRequest = false;
                try {
                    PropertyCollectorFacade.PropertyCollectorUpdates pcUpdates = this._propertyCollectorFacade.waitForUpdates(pcVersion);
                    GlobalPropertyCollectorChangeLog.recordPcChanges(changeRecorder, pcUpdates.getUpdates());
                    pcVersion = pcUpdates.getVersion();
                }
                catch (PropertyCollectorFacade.PropertyCollectorSessionException pcse) {
                    _logger.error("Error while waiting for updates from PropertyCollector. Recreating ChangeLog and PropertyCollectorFacade.", (Throwable)pcse);
                    ChangeLogRecorder changeLogRecorder = ChangeLogRecorder.forCircularChangeLog();
                    changeRecorder = changeLogRecorder.getRecorder();
                    this._changeLog = changeLogRecorder.getLog();
                    this._propertyCollectorFacade = this.createPropertyCollectorFacade();
                    pcVersion = this._propertyCollectorFacade.getVersion();
                }
                catch (Exception e) {
                    String msg = "Non-fatal error while waiting for updates from PropertyCollector: ";
                    if (_logger.isDebugEnabled()) {
                        _logger.debug(msg, (Throwable)e);
                    } else {
                        _logger.warn(msg + e.getMessage());
                    }
                    retryRequest = true;
                }
                if (retryRequest) {
                    this._nonFatalRetry.doDelay();
                    continue;
                }
                this._nonFatalRetry.reset();
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            _logger.error("Fatal error while collecting changes with PropertyCollector. Should reopen the user session.", (Throwable)e);
            this.close();
        }
    }

    private PropertyCollectorFacade createPropertyCollectorFacade() {
        VmomiSession vlsiSession = GlobalPropertyCollectorChangeLog.login(this._authenticator, this._credentials, this._vlsiClient.getBinding());
        this._vlsiSession.set(vlsiSession);
        return new PropertyCollectorFacade(this._vmodlContext, this._vlsiClient, this._pcFiltersFactory, 300);
    }

    private static VmomiSession login(VmomiAuthenticator authenticator, AuthenticationTokenSource credentials, ProtocolBinding binding) {
        VmomiSession session = null;
        DelayedRetry loginRetry = new DelayedRetry(10, 5);
        boolean isConnected = false;
        while (!isConnected) {
            try {
                session = authenticator.login(credentials);
                assert (session != null) : authenticator + " for VCenter server returned null session.";
                Session vlsiSession = binding.createSession(session.getSessionCookie());
                binding.setSession(vlsiSession);
                isConnected = true;
            }
            catch (UnexpectedStatusCodeException usce) {
                if (usce.getStatusCode() == 503) {
                    _logger.warn("VCenter server is unavailable, retrying");
                }
            }
            catch (RuntimeException re) {
                _logger.warn("Login to VCenter server failed, retrying.");
            }
            if (isConnected) continue;
            try {
                loginRetry.doDelay();
            }
            catch (IllegalStateException ise) {
                _logger.error("VCenter server connection retries failed.");
                break;
            }
        }
        if (session == null) {
            throw new IllegalStateException("Could not connect to VCenter server.");
        }
        return session;
    }

    private void closeConnection() {
        GlobalPropertyCollectorChangeLog.closeQuietly(this._vlsiSession.get());
        GlobalPropertyCollectorChangeLog.closeQuietly(this._vlsiClient);
    }

    private static void closeQuietly(Client vlsiClient) {
        try {
            if (vlsiClient != null) {
                vlsiClient.shutdown();
            }
        }
        catch (RuntimeException ex) {
            String msg = "Error while closing VLSI client: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Throwable)ex);
            }
            _logger.warn(msg + ex.getMessage());
        }
    }

    private static void closeQuietly(VmomiSession vmomiSession) {
        try {
            if (vmomiSession != null) {
                vmomiSession.logout();
            }
        }
        catch (NotAuthenticated ignore) {
        }
        catch (RuntimeException ex) {
            String msg = "Error while closing VMOMI session: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Throwable)ex);
            }
            _logger.warn(msg + ex.getMessage());
        }
    }

    private static void recordPcChanges(ChangeRecorder changeRecorder, List<PropertyCollector.FilterUpdate> pcFilterUpdates) {
        assert (pcFilterUpdates != null);
        if (pcFilterUpdates.isEmpty()) {
            return;
        }
        for (PropertyCollector.FilterUpdate filterUpdate : pcFilterUpdates) {
            if (filterUpdate.getObjectSet() == null) continue;
            for (PropertyCollector.ObjectUpdate objUpdate : filterUpdate.getObjectSet()) {
                if (objUpdate == null || objUpdate.getObj() == null || PropertyCollector.ObjectUpdate.Kind.modify.equals((Object)objUpdate.getKind()) && ArrayUtils.isEmpty((Object[])objUpdate.getChangeSet())) continue;
                GlobalPropertyCollectorChangeLog.recordPcChange(changeRecorder, objUpdate);
            }
        }
    }

    private static void recordPcChange(ChangeRecorder changeRecorder, PropertyCollector.ObjectUpdate pcObjectUpdate) {
        assert (pcObjectUpdate != null);
        ManagedObjectReference changedResource = pcObjectUpdate.getObj();
        switch (pcObjectUpdate.getKind()) {
            case enter: {
                _logger.trace("CDC by PropertyCollector spotted CREATE change for resource [{}].", (Object)pcObjectUpdate.getObj());
                changeRecorder.recordCreate((Object)changedResource, changedResource.getType());
                break;
            }
            case modify: {
                ArrayList<String> changedProperties = new ArrayList<String>(pcObjectUpdate.getChangeSet().length);
                for (PropertyCollector.Change propChange : pcObjectUpdate.getChangeSet()) {
                    changedProperties.add(propChange.getName());
                }
                _logger.trace("CDC by PropertyCollector spotted UPDATE change for resource [{}] and properties [{}].", (Object)pcObjectUpdate.getObj(), changedProperties);
                changeRecorder.recordUpdate((Object)changedResource, changedResource.getType(), changedProperties);
                break;
            }
            case leave: {
                _logger.trace("CDC by PropertyCollector spotted DELETE change for resource [{}].", (Object)pcObjectUpdate.getObj());
                changeRecorder.recordDelete((Object)changedResource, changedResource.getType());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported change kind: " + pcObjectUpdate.getKind());
            }
        }
    }

    private static final class DelayedRetry {
        private final int _initialDelay;
        private final int _maxAttempts;
        private int _currentAttempt;

        DelayedRetry(int initialDelay, int maxAttempts) {
            assert (initialDelay > 0);
            assert (maxAttempts > 0);
            this._initialDelay = initialDelay;
            this._maxAttempts = maxAttempts;
            this._currentAttempt = 0;
        }

        void reset() {
            this._currentAttempt = 0;
        }

        void doDelay() {
            if (this._currentAttempt < this._maxAttempts) {
                try {
                    Thread.sleep(1000 * this._initialDelay * this._currentAttempt);
                    ++this._currentAttempt;
                }
                catch (InterruptedException interruptedException) {}
            } else {
                throw new IllegalStateException(String.format("Maximum retry attempts [%s] reached.", this._maxAttempts));
            }
        }
    }
}

