/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cdc.internal.adapters.pc;

import com.vmware.cis.cdc.internal.adapters.pc.GlobalPropertyCollectorChangeLogFactory;
import com.vmware.cis.cdc.internal.adapters.pc.PropertyCollectorChangeLogFactory;
import com.vmware.cis.cdc.internal.adapters.pc.SessionPropertyCollectorChangeLogFactory;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.util.Collection;
import java.util.Collections;

public final class PropertyCollectorChangeLogFactoryBuilder {
    private final VmodlContext _vmodlContext;
    private final boolean _useUnstableVersion;
    private Collection<ManagedObjectReference> _monitoredResources;
    private AuthenticationTokenSource _globalUserCredentials;

    private PropertyCollectorChangeLogFactoryBuilder(VmodlContext vmodlContext, boolean useUnstableVersion) {
        assert (vmodlContext != null);
        this._vmodlContext = vmodlContext;
        this._useUnstableVersion = useUnstableVersion;
    }

    public static PropertyCollectorChangeLogFactoryBuilder forVmodlContext(VmodlContext vmodlContext, boolean useUnstableVersion) {
        return new PropertyCollectorChangeLogFactoryBuilder(vmodlContext, useUnstableVersion);
    }

    public PropertyCollectorChangeLogFactoryBuilder forMonitoredResources(Collection<ManagedObjectReference> monitoredResources) {
        this._monitoredResources = monitoredResources;
        return this;
    }

    public PropertyCollectorChangeLogFactoryBuilder asGlobalChangeLog(AuthenticationTokenSource globalUserCredentials) {
        this._globalUserCredentials = globalUserCredentials;
        return this;
    }

    public PropertyCollectorChangeLogFactory build() {
        if (this._globalUserCredentials != null) {
            return new GlobalPropertyCollectorChangeLogFactory(this._vmodlContext, this._useUnstableVersion, this._globalUserCredentials);
        }
        return new SessionPropertyCollectorChangeLogFactory(this._vmodlContext, this._useUnstableVersion, this._monitoredResources != null ? this._monitoredResources : Collections.emptyList());
    }
}

